/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.common.security;

import java.util.Date;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.idm.api.IdmIdentityService;
import org.flowable.idm.api.Token;
import org.flowable.ui.common.security.BasePersistentTokenService;
import org.springframework.dao.DataAccessException;

public class IdmEnginePersistentTokenService
extends BasePersistentTokenService {
    protected final IdmIdentityService idmIdentityService;

    public IdmEnginePersistentTokenService(IdmIdentityService idmIdentityService) {
        this.idmIdentityService = idmIdentityService;
    }

    @Override
    protected Token loadToken(String tokenId) {
        Token token = (Token)this.idmIdentityService.createTokenQuery().tokenId(tokenId).singleResult();
        if (token != null) {
            return token;
        }
        throw new FlowableObjectNotFoundException("Token with id '" + tokenId + "' not found.");
    }

    @Override
    public void delete(Token token) {
        super.delete(token);
        this.idmIdentityService.deleteToken(token.getId());
    }

    @Override
    public Token createToken(String userId, String remoteAddress, String userAgent) {
        Token token = this.idmIdentityService.newToken(this.generateSeriesData());
        token.setTokenValue(this.generateTokenData());
        token.setTokenDate(new Date());
        token.setIpAddress(remoteAddress);
        token.setUserAgent(userAgent);
        token.setUserId(userId);
        try {
            this.idmIdentityService.saveToken(token);
            return token;
        }
        catch (DataAccessException e) {
            this.logger.error("Failed to save persistent token ", (Throwable)e);
            return token;
        }
    }
}

