/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.common.security;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Date;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.flowable.idm.api.Token;
import org.flowable.ui.common.properties.FlowableCommonAppProperties;
import org.flowable.ui.common.security.PersistentTokenService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.web.authentication.rememberme.AbstractRememberMeServices;
import org.springframework.security.web.authentication.rememberme.CookieTheftException;
import org.springframework.security.web.authentication.rememberme.InvalidCookieException;
import org.springframework.security.web.authentication.rememberme.RememberMeAuthenticationException;
import org.springframework.util.ReflectionUtils;

public class CustomPersistentRememberMeServices
extends AbstractRememberMeServices {
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomPersistentRememberMeServices.class);
    private final PersistentTokenService persistentTokenService;
    private final String tokenDomain;
    private final int tokenMaxAgeInSeconds;
    private final long tokenMaxAgeInMilliseconds;
    private final long tokenRefreshDurationInMilliseconds;

    public CustomPersistentRememberMeServices(FlowableCommonAppProperties properties, UserDetailsService userDetailsService, PersistentTokenService persistentTokenService) {
        super(properties.getSecurity().getRememberMeKey(), userDetailsService);
        this.persistentTokenService = persistentTokenService;
        this.setAlwaysRemember(true);
        FlowableCommonAppProperties.Cookie cookie = properties.getSecurity().getCookie();
        this.tokenMaxAgeInSeconds = (int)cookie.getMaxAge().getSeconds();
        LOGGER.info("Cookie max-age set to {} seconds", (Object)this.tokenMaxAgeInSeconds);
        this.tokenMaxAgeInMilliseconds = (long)this.tokenMaxAgeInSeconds * 1000L;
        String domain = cookie.getDomain();
        if (domain != null) {
            LOGGER.info("Cookie domain set to {}", (Object)domain);
        }
        this.tokenDomain = domain;
        int tokenRefreshSeconds = (int)cookie.getRefreshAge().getSeconds();
        LOGGER.info("Cookie refresh age set to {} seconds", (Object)tokenRefreshSeconds);
        this.tokenRefreshDurationInMilliseconds = (long)tokenRefreshSeconds * 1000L;
        this.setCookieName("FLOWABLE_REMEMBER_ME");
    }

    protected void onLoginSuccess(HttpServletRequest request, HttpServletResponse response, Authentication successfulAuthentication) {
        String userEmail = successfulAuthentication.getName();
        Token token = this.createAndInsertPersistentToken(userEmail, request.getRemoteAddr(), request.getHeader("User-Agent"));
        this.addCookie(token, request, response);
    }

    protected UserDetails processAutoLoginCookie(String[] cookieTokens, HttpServletRequest request, HttpServletResponse response) {
        Token token = this.getPersistentToken(cookieTokens);
        if (new Date().getTime() - token.getTokenDate().getTime() > this.tokenRefreshDurationInMilliseconds) {
            try {
                token = this.persistentTokenService.createToken(token.getUserId(), request.getRequestURI(), request.getHeader("User-Agent"));
                this.addCookie(token, request, response);
            }
            catch (DataAccessException e) {
                LOGGER.error("Failed to update token: ", (Throwable)e);
                throw new RememberMeAuthenticationException("Autologin failed due to data access problem: " + e.getMessage());
            }
        }
        return this.getUserDetailsService().loadUserByUsername(token.getUserId());
    }

    public void logout(HttpServletRequest request, HttpServletResponse response, Authentication authentication) {
        String rememberMeCookie = this.extractRememberMeCookie(request);
        if (rememberMeCookie != null && rememberMeCookie.length() != 0) {
            try {
                String[] cookieTokens = this.decodeCookie(rememberMeCookie);
                Token token = this.getPersistentToken(cookieTokens);
                this.persistentTokenService.delete(token);
            }
            catch (InvalidCookieException ice) {
                LOGGER.info("Invalid cookie, no persistent token could be deleted");
            }
            catch (RememberMeAuthenticationException rmae) {
                LOGGER.debug("No persistent token found, so no token could be deleted");
            }
        }
        super.logout(request, response, authentication);
    }

    private Token getPersistentToken(String[] cookieTokens) {
        if (cookieTokens.length != 2) {
            throw new InvalidCookieException("Cookie token did not contain 2 tokens, but contained '" + Arrays.asList(cookieTokens) + "'");
        }
        String presentedSeries = cookieTokens[0];
        String presentedToken = cookieTokens[1];
        Token token = this.persistentTokenService.getToken(presentedSeries);
        if (token == null) {
            throw new RememberMeAuthenticationException("No persistent token found for series id: " + presentedSeries);
        }
        if (!presentedToken.equals(token.getTokenValue()) && (token = this.persistentTokenService.invalidateCacheEntryAndGetToken(presentedSeries, true)) != null && !presentedToken.equals(token.getTokenValue())) {
            this.persistentTokenService.delete(token);
            throw new CookieTheftException("Invalid remember-me token (Series/token) mismatch. Implies previous cookie theft attack.");
        }
        if (new Date().getTime() - token.getTokenDate().getTime() > this.tokenMaxAgeInMilliseconds) {
            throw new RememberMeAuthenticationException("Remember-me login has expired");
        }
        return token;
    }

    private void addCookie(Token token, HttpServletRequest request, HttpServletResponse response) {
        this.setCookie(new String[]{token.getId(), token.getTokenValue()}, this.tokenMaxAgeInSeconds, request, response);
    }

    protected void setCookie(String[] tokens, int maxAge, HttpServletRequest request, HttpServletResponse response) {
        String xForwardedProtoHeader;
        String cookieValue = this.encodeCookie(tokens);
        Cookie cookie = new Cookie(this.getCookieName(), cookieValue);
        cookie.setMaxAge(maxAge);
        cookie.setPath("/");
        if (this.tokenDomain != null) {
            cookie.setDomain(this.tokenDomain);
        }
        if ((xForwardedProtoHeader = request.getHeader("X-Forwarded-Proto")) != null) {
            cookie.setSecure("https".equals(xForwardedProtoHeader) || request.isSecure());
        } else {
            cookie.setSecure(request.isSecure());
        }
        Method setHttpOnlyMethod = ReflectionUtils.findMethod(Cookie.class, (String)"setHttpOnly", (Class[])new Class[]{Boolean.TYPE});
        if (setHttpOnlyMethod != null) {
            ReflectionUtils.invokeMethod((Method)setHttpOnlyMethod, (Object)cookie, (Object[])new Object[]{Boolean.TRUE});
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Note: Cookie will not be marked as HttpOnly because you are not using Servlet 3.0 (Cookie#setHttpOnly(boolean) was not found).");
        }
        response.addCookie(cookie);
    }

    public Token createAndInsertPersistentToken(String userId, String remoteAddress, String userAgent) {
        return this.persistentTokenService.createToken(userId, remoteAddress, userAgent);
    }
}

