/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.admin.rest.client;

import com.fasterxml.jackson.databind.JsonNode;
import org.flowable.ui.admin.domain.EndpointType;
import org.flowable.ui.admin.domain.ServerConfig;
import org.flowable.ui.admin.rest.client.AbstractClientResource;
import org.flowable.ui.admin.service.engine.ContentItemService;
import org.flowable.ui.admin.service.engine.exception.FlowableServiceException;
import org.flowable.ui.common.service.exception.BadRequestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ContentItemClientResource
extends AbstractClientResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContentItemClientResource.class);
    @Autowired
    protected ContentItemService clientService;

    @GetMapping(value={"/rest/admin/content-items/{contentItemId}"}, produces={"application/json"})
    public JsonNode getContentItem(@PathVariable String contentItemId) throws BadRequestException {
        ServerConfig serverConfig = this.retrieveServerConfig(EndpointType.CONTENT);
        try {
            return this.clientService.getContentItem(serverConfig, contentItemId);
        }
        catch (FlowableServiceException e) {
            LOGGER.error("Error getting content item {}", (Object)contentItemId, (Object)e);
            throw new BadRequestException(e.getMessage());
        }
    }
}

