/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.admin.rest.client;

import com.fasterxml.jackson.databind.JsonNode;
import org.flowable.ui.admin.domain.EndpointType;
import org.flowable.ui.admin.domain.ServerConfig;
import org.flowable.ui.admin.rest.client.AbstractClientResource;
import org.flowable.ui.admin.service.engine.AppDefinitionService;
import org.flowable.ui.admin.service.engine.exception.FlowableServiceException;
import org.flowable.ui.common.service.exception.BadRequestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class AppDefinitionClientResource
extends AbstractClientResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(AppDefinitionClientResource.class);
    @Autowired
    protected AppDefinitionService clientService;

    @GetMapping(value={"/rest/admin/app-definitions/{definitionId}"}, produces={"application/json"})
    public JsonNode getCaseDefinition(@PathVariable String definitionId) {
        ServerConfig serverConfig = this.retrieveServerConfig(EndpointType.APP);
        try {
            return this.clientService.getAppDefinition(serverConfig, definitionId);
        }
        catch (FlowableServiceException e) {
            LOGGER.error("Error getting app definition {}", (Object)definitionId, (Object)e);
            throw new BadRequestException(e.getMessage());
        }
    }

    @GetMapping(value={"/rest/admin/app-definitions/{definitionId}/process-definitions"}, produces={"application/json"})
    public JsonNode getProcessDefinitions(@PathVariable String definitionId, @RequestParam(name="deploymentId", required=true) String deploymentId) {
        ServerConfig serverConfig = this.retrieveServerConfig(EndpointType.PROCESS);
        try {
            return this.clientService.getAppDefinitionProcessDefinitions(serverConfig, deploymentId);
        }
        catch (FlowableServiceException e) {
            LOGGER.error("Error getting process definitions for app definition {}", (Object)definitionId, (Object)e);
            throw new BadRequestException(e.getMessage());
        }
    }

    @GetMapping(value={"/rest/admin/app-definitions/{definitionId}/case-definitions"}, produces={"application/json"})
    public JsonNode getCaseDefinitions(@PathVariable String definitionId, @RequestParam(name="deploymentId", required=true) String deploymentId) {
        ServerConfig serverConfig = this.retrieveServerConfig(EndpointType.CMMN);
        try {
            return this.clientService.getAppDefinitionCaseDefinitions(serverConfig, deploymentId);
        }
        catch (FlowableServiceException e) {
            LOGGER.error("Error getting case definitions for app definition {}", (Object)definitionId, (Object)e);
            throw new BadRequestException(e.getMessage());
        }
    }

    @GetMapping(value={"/rest/admin/app-definitions/{definitionId}/decision-tables"}, produces={"application/json"})
    public JsonNode getDecisionTables(@PathVariable String definitionId, @RequestParam(name="deploymentId", required=true) String deploymentId) {
        ServerConfig serverConfig = this.retrieveServerConfig(EndpointType.DMN);
        try {
            return this.clientService.getAppDefinitionDecisionTables(serverConfig, deploymentId);
        }
        catch (FlowableServiceException e) {
            LOGGER.error("Error getting decision tables for app definition {}", (Object)definitionId, (Object)e);
            throw new BadRequestException(e.getMessage());
        }
    }

    @GetMapping(value={"/rest/admin/app-definitions/{definitionId}/form-definitions"}, produces={"application/json"})
    public JsonNode getFormDefinitions(@PathVariable String definitionId, @RequestParam(name="deploymentId", required=true) String deploymentId) {
        ServerConfig serverConfig = this.retrieveServerConfig(EndpointType.FORM);
        try {
            return this.clientService.getAppDefinitionFormDefinitions(serverConfig, deploymentId);
        }
        catch (FlowableServiceException e) {
            LOGGER.error("Error getting form definitions for app definition {}", (Object)definitionId, (Object)e);
            throw new BadRequestException(e.getMessage());
        }
    }
}

