/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.admin.service.engine;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.flowable.ui.admin.domain.EndpointType;
import org.flowable.ui.admin.domain.ServerConfig;
import org.flowable.ui.admin.service.engine.FlowableClientService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProcessEngineInfoService {
    public static final String PROCESS_ENGINE_INFO_URL = "management/engine";
    public static final String DMN_ENGINE_INFO_URL = "dmn-management/engine";
    public static final String FORM_ENGINE_INFO_URL = "form-management/engine";
    public static final String CONTENT_ENGINE_INFO_URL = "content-management/engine";
    public static final String CMMN_ENGINE_INFO_URL = "cmmn-management/engine";
    public static final String APP_ENGINE_INFO_URL = "app-management/engine";
    @Autowired
    protected FlowableClientService clientUtil;
    @Autowired
    protected ObjectMapper objectMapper;

    public JsonNode getEngineInfo(ServerConfig serverConfig) {
        EndpointType endpointType = EndpointType.valueOf(serverConfig.getEndpointType());
        URIBuilder builder = null;
        switch (endpointType) {
            case PROCESS: {
                builder = this.clientUtil.createUriBuilder(PROCESS_ENGINE_INFO_URL);
                break;
            }
            case DMN: {
                builder = this.clientUtil.createUriBuilder(DMN_ENGINE_INFO_URL);
                break;
            }
            case FORM: {
                builder = this.clientUtil.createUriBuilder(FORM_ENGINE_INFO_URL);
                break;
            }
            case CONTENT: {
                builder = this.clientUtil.createUriBuilder(CONTENT_ENGINE_INFO_URL);
                break;
            }
            case CMMN: {
                builder = this.clientUtil.createUriBuilder(CMMN_ENGINE_INFO_URL);
                break;
            }
            case APP: {
                builder = this.clientUtil.createUriBuilder(APP_ENGINE_INFO_URL);
            }
        }
        HttpGet get = new HttpGet(this.clientUtil.getServerUrl(serverConfig, builder));
        return this.clientUtil.executeRequest((HttpUriRequest)get, serverConfig);
    }
}

