/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.admin.service.engine;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.flowable.ui.admin.domain.ServerConfig;
import org.flowable.ui.admin.service.engine.FlowableClientService;
import org.flowable.ui.admin.service.engine.exception.FlowableServiceException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FormInstanceService {
    @Autowired
    protected FlowableClientService clientUtil;
    @Autowired
    protected ObjectMapper objectMapper;

    public JsonNode listFormInstances(ServerConfig serverConfig, Map<String, String[]> parameterMap) {
        URIBuilder builder = this.clientUtil.createUriBuilder("form/form-instances");
        for (String name : parameterMap.keySet()) {
            builder.addParameter(name, parameterMap.get(name)[0]);
        }
        HttpGet get = new HttpGet(this.clientUtil.getServerUrl(serverConfig, builder.toString()));
        return this.clientUtil.executeRequest((HttpUriRequest)get, serverConfig);
    }

    public JsonNode getFormInstance(ServerConfig serverConfig, String formInstanceId) {
        HttpGet get = new HttpGet(this.clientUtil.getServerUrl(serverConfig, "form/form-instance/" + formInstanceId));
        return this.clientUtil.executeRequest((HttpUriRequest)get, serverConfig);
    }

    public JsonNode getFormInstances(ServerConfig serverConfig, ObjectNode objectNode) {
        JsonNode resultNode = null;
        try {
            URIBuilder builder = this.clientUtil.createUriBuilder("query/form-instances");
            HttpPost post = this.clientUtil.createPost(builder.toString(), serverConfig);
            post.setEntity((HttpEntity)this.clientUtil.createStringEntity(objectNode.toString()));
            resultNode = this.clientUtil.executeRequest((HttpUriRequest)post, serverConfig);
        }
        catch (Exception ex) {
            throw new FlowableServiceException(ex.getMessage(), ex);
        }
        return resultNode;
    }

    public JsonNode getFormInstanceFormFieldValues(ServerConfig serverConfig, String formInstanceId) {
        ObjectNode returnNode = null;
        try {
            returnNode = this.objectMapper.createObjectNode();
            ObjectNode requestNode = this.objectMapper.createObjectNode();
            requestNode.put("formInstanceId", formInstanceId);
            URIBuilder builder = this.clientUtil.createUriBuilder("form/form-instance-model");
            HttpPost post = this.clientUtil.createPost(builder.toString(), serverConfig);
            post.setEntity((HttpEntity)this.clientUtil.createStringEntity(requestNode.toString()));
            JsonNode resultNode = this.clientUtil.executeRequest((HttpUriRequest)post, serverConfig);
            ArrayNode formFieldValues = this.objectMapper.createArrayNode();
            if (resultNode != null && resultNode.has("fields") && resultNode.get("fields").isArray()) {
                ArrayNode fieldsNode = (ArrayNode)resultNode.get("fields");
                for (JsonNode fieldNode : fieldsNode) {
                    ObjectNode formFieldValue = this.objectMapper.createObjectNode();
                    formFieldValue.set("id", fieldNode.get("id"));
                    formFieldValue.set("name", fieldNode.get("name"));
                    formFieldValue.set("type", fieldNode.get("type"));
                    formFieldValue.set("value", fieldNode.get("value"));
                    formFieldValues.add((JsonNode)formFieldValue);
                }
            }
            returnNode.put("size", formFieldValues.size());
            returnNode.put("total", formFieldValues.size());
            returnNode.set("data", (JsonNode)formFieldValues);
        }
        catch (Exception ex) {
            throw new FlowableServiceException(ex.getMessage(), ex);
        }
        return returnNode;
    }
}

