/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.admin.service.engine;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Map;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.flowable.ui.admin.domain.ServerConfig;
import org.flowable.ui.admin.service.engine.FlowableClientService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DecisionHistoricExecutionService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DecisionHistoricExecutionService.class);
    @Autowired
    protected FlowableClientService clientUtil;

    public JsonNode listHistoricDecisionExecutions(ServerConfig serverConfig, Map<String, String[]> parameterMap) {
        URIBuilder builder = this.clientUtil.createUriBuilder("dmn-history/historic-decision-executions");
        for (String name : parameterMap.keySet()) {
            builder.addParameter(name, parameterMap.get(name)[0]);
        }
        HttpGet get = new HttpGet(this.clientUtil.getServerUrl(serverConfig, builder.toString()));
        return this.clientUtil.executeRequest((HttpUriRequest)get, serverConfig);
    }

    public JsonNode getHistoricDecisionExecution(ServerConfig serverConfig, String executionId) {
        HttpGet get = new HttpGet(this.clientUtil.getServerUrl(serverConfig, "dmn-history/historic-decision-executions/" + executionId));
        return this.clientUtil.executeRequest((HttpUriRequest)get, serverConfig);
    }

    public JsonNode getHistoricDecisionExecutionAuditData(ServerConfig serverConfig, String executionId) {
        HttpGet get = new HttpGet(this.clientUtil.getServerUrl(serverConfig, "dmn-history/historic-decision-executions/" + executionId + "/auditdata"));
        return this.clientUtil.executeRequest((HttpUriRequest)get, serverConfig);
    }
}

