/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.admin.service.engine;

import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.flowable.ui.admin.properties.FlowableAdminAppProperties;

public abstract class AbstractEncryptingService {
    public static final String AES_KEY = "AES";
    public static final String AES_CYPHER = "AES/CBC/PKCS5PADDING";
    protected IvParameterSpec initializationVectorSpec;
    protected SecretKeySpec secretKeySpec;

    protected AbstractEncryptingService(FlowableAdminAppProperties properties) {
        FlowableAdminAppProperties.Encryption encryption = properties.getSecurity().getEncryption();
        String ivString = encryption.getCredentialsIVSpec();
        String secretString = encryption.getCredentialsSecretSpec();
        this.initializationVectorSpec = new IvParameterSpec(ivString.getBytes(StandardCharsets.UTF_8));
        this.secretKeySpec = new SecretKeySpec(secretString.getBytes(StandardCharsets.UTF_8), AES_KEY);
    }

    protected String encrypt(String value) {
        try {
            Cipher cipher = Cipher.getInstance(AES_CYPHER);
            cipher.init(1, (Key)this.secretKeySpec, this.initializationVectorSpec);
            byte[] encrypted = cipher.doFinal(value.getBytes());
            return new String(Base64.getEncoder().encode(encrypted), StandardCharsets.UTF_8);
        }
        catch (GeneralSecurityException nsae) {
            throw new RuntimeException(nsae);
        }
    }

    protected String decrypt(String encrypted) {
        try {
            Cipher cipher = Cipher.getInstance(AES_CYPHER);
            cipher.init(2, (Key)this.secretKeySpec, this.initializationVectorSpec);
            byte[] original = cipher.doFinal(Base64.getDecoder().decode(encrypted.getBytes(StandardCharsets.UTF_8)));
            return new String(original, StandardCharsets.UTF_8);
        }
        catch (GeneralSecurityException nsae) {
            throw new RuntimeException(nsae);
        }
    }
}

