/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.admin.service.engine;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.flowable.cmmn.converter.CmmnXmlConverter;
import org.flowable.cmmn.model.CmmnModel;
import org.flowable.ui.admin.domain.ServerConfig;
import org.flowable.ui.admin.service.engine.FlowableClientService;
import org.flowable.ui.admin.service.engine.exception.FlowableServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CaseDefinitionService {
    private static final Logger LOGGER = LoggerFactory.getLogger(CaseDefinitionService.class);
    @Autowired
    protected FlowableClientService clientUtil;

    public JsonNode listCaseDefinitions(ServerConfig serverConfig, Map<String, String[]> parameterMap) {
        URIBuilder builder = this.clientUtil.createUriBuilder("cmmn-repository/case-definitions");
        for (String name : parameterMap.keySet()) {
            builder.addParameter(name, parameterMap.get(name)[0]);
        }
        HttpGet get = new HttpGet(this.clientUtil.getServerUrl(serverConfig, builder.toString()));
        return this.clientUtil.executeRequest((HttpUriRequest)get, serverConfig);
    }

    public JsonNode getCaseDefinition(ServerConfig serverConfig, String caseDefinitionId) {
        HttpGet get = new HttpGet(this.clientUtil.getServerUrl(serverConfig, "cmmn-repository/case-definitions/" + caseDefinitionId));
        return this.clientUtil.executeRequest((HttpUriRequest)get, serverConfig);
    }

    public CmmnModel getCaseDefinitionModel(ServerConfig serverConfig, String definitionId) {
        HttpGet get = new HttpGet(this.clientUtil.getServerUrl(serverConfig, "cmmn-repository/case-definitions/" + definitionId + "/resourcedata"));
        return this.executeRequestForXML((HttpUriRequest)get, serverConfig, 200);
    }

    public JsonNode getCaseDefinitionForms(ServerConfig serverConfig, String caseDefinitionId) {
        HttpGet get = new HttpGet(this.clientUtil.getServerUrl(serverConfig, "cmmn-repository/case-definitions/" + caseDefinitionId + "/form-definitions"));
        return this.clientUtil.executeRequest((HttpUriRequest)get, serverConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected CmmnModel executeRequestForXML(HttpUriRequest request, ServerConfig serverConfig, int expectedStatusCode) {
        FlowableServiceException exception;
        block26: {
            CloseableHttpResponse response;
            CloseableHttpClient client;
            block24: {
                CmmnModel cmmnModel;
                block25: {
                    boolean success;
                    exception = null;
                    client = this.clientUtil.getHttpClient(serverConfig);
                    response = client.execute(request);
                    InputStream responseContent = response.getEntity().getContent();
                    XMLInputFactory xif = XMLInputFactory.newInstance();
                    InputStreamReader in = new InputStreamReader(responseContent, StandardCharsets.UTF_8);
                    XMLStreamReader xtr = xif.createXMLStreamReader(in);
                    CmmnModel cmmmnModel = new CmmnXmlConverter().convertToCmmnModel(xtr);
                    boolean bl = success = response.getStatusLine() != null && response.getStatusLine().getStatusCode() == expectedStatusCode;
                    if (!success) break block24;
                    cmmnModel = cmmmnModel;
                    if (response == null) break block25;
                    response.close();
                }
                try {
                    client.close();
                }
                catch (Exception e) {
                    LOGGER.warn("Error closing http client instance", (Throwable)e);
                }
                return cmmnModel;
            }
            try {
                try {
                    exception = new FlowableServiceException("An error occurred while calling Flowable: " + response.getStatusLine());
                    break block26;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                    finally {
                        if (response != null) {
                            response.close();
                        }
                    }
                }
                catch (Exception e) {
                    LOGGER.warn("Error consuming response from uri {}", (Object)request.getURI(), (Object)e);
                    exception = this.clientUtil.wrapException(e, request);
                }
            }
            catch (Exception e) {
                LOGGER.error("Error executing request to uri {}", (Object)request.getURI(), (Object)e);
                exception = this.clientUtil.wrapException(e, request);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                try {
                    client.close();
                }
                catch (Exception e) {
                    LOGGER.warn("Error closing http client instance", (Throwable)e);
                }
            }
        }
        if (exception != null) {
            throw exception;
        }
        return null;
    }
}

