/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.admin.domain.generator;

import java.util.List;
import org.flowable.ui.admin.dto.ServerConfigRepresentation;
import org.flowable.ui.admin.service.engine.ServerConfigService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;

public class MinimalDataGenerator
implements ApplicationListener<ContextRefreshedEvent> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MinimalDataGenerator.class);
    protected final ServerConfigService serverConfigService;

    public MinimalDataGenerator(ServerConfigService serverConfigService) {
        this.serverConfigService = serverConfigService;
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        if (event.getApplicationContext().getParent() == null) {
            LOGGER.info("Verifying if minimal data is present");
            List<ServerConfigRepresentation> serverConfigs = this.serverConfigService.findAll();
            if (serverConfigs.size() == 0) {
                LOGGER.info("No server configurations found, creating default server configurations");
                this.serverConfigService.createDefaultServerConfigs();
            } else if (serverConfigs.size() == 4) {
                this.serverConfigService.createCmmnDefaultServerConfig();
            } else if (serverConfigs.size() == 5) {
                this.serverConfigService.createAppDefaultServerConfig();
            }
        }
    }
}

