/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.rest.service.api.repository;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.flowable.engine.repository.Model;
import org.flowable.rest.service.api.repository.BaseModelResource;
import org.flowable.rest.service.api.repository.ModelRequest;
import org.flowable.rest.service.api.repository.ModelResponse;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Models"}, description="Manage Models", authorizations={@Authorization(value="basicAuth")})
public class ModelResource
extends BaseModelResource {
    @ApiOperation(value="Get a model", tags={"Models"})
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates the model was found and returned."), @ApiResponse(code=404, message="Indicates the requested model was not found.")})
    @GetMapping(value={"/repository/models/{modelId}"}, produces={"application/json"})
    public ModelResponse getModel(@ApiParam(name="modelId") @PathVariable String modelId, HttpServletRequest request) {
        Model model = this.getModelFromRequest(modelId);
        return this.restResponseFactory.createModelResponse(model);
    }

    @ApiOperation(value="Update a model", tags={"Models"}, notes="All request values are optional. For example, you can only include the name attribute in the request body JSON-object, only updating the name of the model, leaving all other fields unaffected. When an attribute is explicitly included and is set to null, the model-value will be updated to null. ")
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates the model was found and updated."), @ApiResponse(code=404, message="Indicates the requested model was not found.")})
    @PutMapping(value={"/repository/models/{modelId}"}, produces={"application/json"})
    public ModelResponse updateModel(@ApiParam(name="modelId") @PathVariable String modelId, @RequestBody ModelRequest modelRequest, HttpServletRequest request) {
        Model model = this.getModelFromRequest(modelId);
        if (modelRequest.isCategoryChanged()) {
            model.setCategory(modelRequest.getCategory());
        }
        if (modelRequest.isDeploymentChanged()) {
            model.setDeploymentId(modelRequest.getDeploymentId());
        }
        if (modelRequest.isKeyChanged()) {
            model.setKey(modelRequest.getKey());
        }
        if (modelRequest.isMetaInfoChanged()) {
            model.setMetaInfo(modelRequest.getMetaInfo());
        }
        if (modelRequest.isNameChanged()) {
            model.setName(modelRequest.getName());
        }
        if (modelRequest.isVersionChanged()) {
            model.setVersion(modelRequest.getVersion());
        }
        if (modelRequest.isTenantIdChanged()) {
            model.setTenantId(modelRequest.getTenantId());
        }
        this.repositoryService.saveModel(model);
        return this.restResponseFactory.createModelResponse(model);
    }

    @ApiOperation(value="Delete a model", tags={"Models"})
    @ApiResponses(value={@ApiResponse(code=204, message="Indicates the model was found and has been deleted. Response-body is intentionally empty."), @ApiResponse(code=404, message="Indicates the requested model was not found.")})
    @DeleteMapping(value={"/repository/models/{modelId}"})
    public void deleteModel(@ApiParam(name="modelId") @PathVariable String modelId, HttpServletResponse response) {
        Model model = this.getModelFromRequest(modelId);
        this.repositoryService.deleteModel(model.getId());
        response.setStatus(HttpStatus.NO_CONTENT.value());
    }
}

