/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.rest.service.api.management;

import org.flowable.batch.api.Batch;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.engine.ManagementService;
import org.flowable.rest.service.api.BpmnRestApiInterceptor;
import org.springframework.beans.factory.annotation.Autowired;

public class BatchBaseResource {
    @Autowired
    protected ManagementService managementService;
    @Autowired(required=false)
    protected BpmnRestApiInterceptor restApiInterceptor;

    protected Batch getBatchById(String batchId) {
        Batch batch = (Batch)this.managementService.createBatchQuery().batchId(batchId).singleResult();
        this.validateBatch(batch, batchId);
        return batch;
    }

    protected void validateBatch(Batch batch, String batchId) {
        if (batch == null) {
            throw new FlowableObjectNotFoundException("Could not find a batch with id '" + batchId + "'.", Batch.class);
        }
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.accessBatchInfoById(batch);
        }
    }
}

