/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.validation.validator.impl;

import java.util.List;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.FieldExtension;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.TaskWithFieldExtensions;
import org.flowable.validation.ValidationError;
import org.flowable.validation.validator.ProcessLevelValidator;

public abstract class ExternalInvocationTaskValidator
extends ProcessLevelValidator {
    protected void validateFieldDeclarationsForEmail(Process process, TaskWithFieldExtensions task, List<FieldExtension> fieldExtensions, List<ValidationError> errors) {
        boolean toDefined = false;
        boolean textOrHtmlDefined = false;
        for (FieldExtension fieldExtension : fieldExtensions) {
            if (fieldExtension.getFieldName().equals("to")) {
                toDefined = true;
            }
            if (fieldExtension.getFieldName().equals("html")) {
                textOrHtmlDefined = true;
            }
            if (fieldExtension.getFieldName().equals("htmlVar")) {
                textOrHtmlDefined = true;
            }
            if (fieldExtension.getFieldName().equals("text")) {
                textOrHtmlDefined = true;
            }
            if (!fieldExtension.getFieldName().equals("textVar")) continue;
            textOrHtmlDefined = true;
        }
        if (!toDefined) {
            this.addError(errors, "flowable-mailtask-no-recipient", process, (BaseElement)task, "No recipient is defined on the mail activity");
        }
        if (!textOrHtmlDefined) {
            this.addError(errors, "flowable-mailtask-no-content", process, (BaseElement)task, "Text, html, textVar or htmlVar field should be provided");
        }
    }

    protected void validateFieldDeclarationsForShell(Process process, TaskWithFieldExtensions task, List<FieldExtension> fieldExtensions, List<ValidationError> errors) {
        boolean shellCommandDefined = false;
        for (FieldExtension fieldExtension : fieldExtensions) {
            String fieldName = fieldExtension.getFieldName();
            String fieldValue = fieldExtension.getStringValue();
            if (fieldName.equals("command")) {
                shellCommandDefined = true;
            }
            if (!fieldName.equals("wait") && !fieldName.equals("redirectError") && !fieldName.equals("cleanEnv") || fieldValue.toLowerCase().equals("true") || fieldValue.toLowerCase().equals("false")) continue;
            this.addError(errors, "flowable-shelltask-invalid-param", process, (BaseElement)task, "Undefined parameter value for shell field");
        }
        if (!shellCommandDefined) {
            this.addError(errors, "flowable-shelltask-no-command", process, (BaseElement)task, "No shell command is defined on the shell activity");
        }
    }

    protected void validateFieldDeclarationsForDmn(Process process, TaskWithFieldExtensions task, List<FieldExtension> fieldExtensions, List<ValidationError> errors) {
        boolean keyDefined = false;
        for (FieldExtension fieldExtension : fieldExtensions) {
            String fieldName = fieldExtension.getFieldName();
            String fieldValue = fieldExtension.getStringValue();
            if (!fieldName.equals("decisionTableReferenceKey") || fieldValue == null || fieldValue.length() <= 0) continue;
            keyDefined = true;
        }
        if (!keyDefined) {
            this.addError(errors, "flowable-dmntask-no-decision-table-key", process, (BaseElement)task, "No decision table reference key is defined on the dmn activity");
        }
    }
}

