/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.job.service.impl.cmd;

import org.apache.commons.lang3.StringUtils;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.job.service.JobServiceConfiguration;
import org.flowable.job.service.impl.persistence.entity.ExternalWorkerJobEntity;
import org.flowable.job.service.impl.persistence.entity.ExternalWorkerJobEntityManager;

public class UnacquireExternalWorkerJobCmd
implements Command<Void> {
    protected final String jobId;
    protected final String workerId;
    protected final JobServiceConfiguration jobServiceConfiguration;

    public UnacquireExternalWorkerJobCmd(String jobId, String workerId, JobServiceConfiguration jobServiceConfiguration) {
        this.jobId = jobId;
        this.workerId = workerId;
        this.jobServiceConfiguration = jobServiceConfiguration;
    }

    public Void execute(CommandContext commandContext) {
        if (StringUtils.isEmpty((CharSequence)this.jobId)) {
            throw new FlowableIllegalArgumentException("job id must not be empty");
        }
        if (StringUtils.isEmpty((CharSequence)this.workerId)) {
            throw new FlowableIllegalArgumentException("worker id must not be empty");
        }
        ExternalWorkerJobEntityManager externalWorkerJobEntityManager = this.jobServiceConfiguration.getExternalWorkerJobEntityManager();
        ExternalWorkerJobEntity jobEntity = (ExternalWorkerJobEntity)externalWorkerJobEntityManager.findById(this.jobId);
        if (jobEntity == null) {
            throw new FlowableException("Could not find job for id " + this.jobId);
        }
        if (!jobEntity.getLockOwner().equals(this.workerId)) {
            throw new FlowableException("Job is locked with a different worker id");
        }
        jobEntity.setLockExpirationTime(null);
        jobEntity.setLockOwner(null);
        externalWorkerJobEntityManager.update(jobEntity);
        return null;
    }
}

