/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.job.service.impl.cmd;

import java.util.List;
import org.flowable.engine.common.impl.interceptor.Command;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.flowable.job.api.HistoryJob;
import org.flowable.job.api.JobInfo;
import org.flowable.job.service.impl.HistoryJobQueryImpl;
import org.flowable.job.service.impl.util.CommandContextUtil;

public class UnacquireOwnedHistoryJobsCmd
implements Command<Void> {
    private final String lockOwner;
    private final String tenantId;

    public UnacquireOwnedHistoryJobsCmd(String lockOwner, String tenantId) {
        this.lockOwner = lockOwner;
        this.tenantId = tenantId;
    }

    public Void execute(CommandContext commandContext) {
        HistoryJobQueryImpl jobQuery = new HistoryJobQueryImpl(commandContext);
        jobQuery.lockOwner(this.lockOwner);
        jobQuery.jobTenantId(this.tenantId);
        List<HistoryJob> jobs = CommandContextUtil.getHistoryJobEntityManager(commandContext).findHistoryJobsByQueryCriteria(jobQuery);
        for (HistoryJob job : jobs) {
            CommandContextUtil.getJobManager(commandContext).unacquire((JobInfo)job);
        }
        return null;
    }
}

