/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.job.service.impl.cmd;

import java.io.Serializable;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.flowable.engine.common.impl.interceptor.Command;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.flowable.job.api.Job;
import org.flowable.job.service.InternalJobManager;
import org.flowable.job.service.impl.util.CommandContextUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LockExclusiveJobCmd
implements Command<Object>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(LockExclusiveJobCmd.class);
    protected Job job;

    public LockExclusiveJobCmd(Job job) {
        this.job = job;
    }

    public Object execute(CommandContext commandContext) {
        InternalJobManager jobScopeInterface;
        if (this.job == null) {
            throw new FlowableIllegalArgumentException("job is null");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Executing lock exclusive job {} {}", (Object)this.job.getId(), (Object)this.job.getExecutionId());
        }
        if (this.job.isExclusive() && this.job.getExecutionId() != null && (jobScopeInterface = CommandContextUtil.getJobServiceConfiguration().getInternalJobManager()) != null) {
            jobScopeInterface.updateJobScopeLockTime(this.job);
        }
        return null;
    }
}

