/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.job.service.impl;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.flowable.engine.common.impl.AbstractQuery;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.flowable.engine.common.impl.interceptor.CommandExecutor;
import org.flowable.job.api.Job;
import org.flowable.job.api.TimerJobQuery;
import org.flowable.job.service.impl.JobQueryProperty;
import org.flowable.job.service.impl.util.CommandContextUtil;

public class TimerJobQueryImpl
extends AbstractQuery<TimerJobQuery, Job>
implements TimerJobQuery,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String id;
    protected String processInstanceId;
    protected String executionId;
    protected String handlerType;
    protected String processDefinitionId;
    protected boolean executable;
    protected boolean onlyTimers;
    protected boolean onlyMessages;
    protected Date duedateHigherThan;
    protected Date duedateLowerThan;
    protected Date duedateHigherThanOrEqual;
    protected Date duedateLowerThanOrEqual;
    protected boolean withException;
    protected String exceptionMessage;
    protected String tenantId;
    protected String tenantIdLike;
    protected boolean withoutTenantId;

    public TimerJobQueryImpl() {
    }

    public TimerJobQueryImpl(CommandContext commandContext) {
        super(commandContext);
    }

    public TimerJobQueryImpl(CommandExecutor commandExecutor) {
        super(commandExecutor);
    }

    public TimerJobQueryImpl jobId(String jobId) {
        if (jobId == null) {
            throw new FlowableIllegalArgumentException("Provided job id is null");
        }
        this.id = jobId;
        return this;
    }

    public TimerJobQueryImpl processInstanceId(String processInstanceId) {
        if (processInstanceId == null) {
            throw new FlowableIllegalArgumentException("Provided process instance id is null");
        }
        this.processInstanceId = processInstanceId;
        return this;
    }

    public TimerJobQueryImpl processDefinitionId(String processDefinitionId) {
        if (processDefinitionId == null) {
            throw new FlowableIllegalArgumentException("Provided process definition id is null");
        }
        this.processDefinitionId = processDefinitionId;
        return this;
    }

    public TimerJobQueryImpl executionId(String executionId) {
        if (executionId == null) {
            throw new FlowableIllegalArgumentException("Provided execution id is null");
        }
        this.executionId = executionId;
        return this;
    }

    public TimerJobQueryImpl handlerType(String handlerType) {
        if (handlerType == null) {
            throw new FlowableIllegalArgumentException("Provided handlerType is null");
        }
        this.handlerType = handlerType;
        return this;
    }

    public TimerJobQueryImpl executable() {
        this.executable = true;
        return this;
    }

    public TimerJobQueryImpl timers() {
        if (this.onlyMessages) {
            throw new FlowableIllegalArgumentException("Cannot combine onlyTimers() with onlyMessages() in the same query");
        }
        this.onlyTimers = true;
        return this;
    }

    public TimerJobQueryImpl messages() {
        if (this.onlyTimers) {
            throw new FlowableIllegalArgumentException("Cannot combine onlyTimers() with onlyMessages() in the same query");
        }
        this.onlyMessages = true;
        return this;
    }

    public TimerJobQueryImpl duedateHigherThan(Date date) {
        if (date == null) {
            throw new FlowableIllegalArgumentException("Provided date is null");
        }
        this.duedateHigherThan = date;
        return this;
    }

    public TimerJobQueryImpl duedateLowerThan(Date date) {
        if (date == null) {
            throw new FlowableIllegalArgumentException("Provided date is null");
        }
        this.duedateLowerThan = date;
        return this;
    }

    public TimerJobQueryImpl withException() {
        this.withException = true;
        return this;
    }

    public TimerJobQueryImpl exceptionMessage(String exceptionMessage) {
        if (exceptionMessage == null) {
            throw new FlowableIllegalArgumentException("Provided exception message is null");
        }
        this.exceptionMessage = exceptionMessage;
        return this;
    }

    public TimerJobQueryImpl jobTenantId(String tenantId) {
        if (tenantId == null) {
            throw new FlowableIllegalArgumentException("Provided tentant id is null");
        }
        this.tenantId = tenantId;
        return this;
    }

    public TimerJobQueryImpl jobTenantIdLike(String tenantIdLike) {
        if (tenantIdLike == null) {
            throw new FlowableIllegalArgumentException("Provided tentant id is null");
        }
        this.tenantIdLike = tenantIdLike;
        return this;
    }

    public TimerJobQueryImpl jobWithoutTenantId() {
        this.withoutTenantId = true;
        return this;
    }

    public TimerJobQuery orderByJobDuedate() {
        return (TimerJobQuery)this.orderBy(JobQueryProperty.DUEDATE);
    }

    public TimerJobQuery orderByExecutionId() {
        return (TimerJobQuery)this.orderBy(JobQueryProperty.EXECUTION_ID);
    }

    public TimerJobQuery orderByJobId() {
        return (TimerJobQuery)this.orderBy(JobQueryProperty.JOB_ID);
    }

    public TimerJobQuery orderByProcessInstanceId() {
        return (TimerJobQuery)this.orderBy(JobQueryProperty.PROCESS_INSTANCE_ID);
    }

    public TimerJobQuery orderByJobRetries() {
        return (TimerJobQuery)this.orderBy(JobQueryProperty.RETRIES);
    }

    public TimerJobQuery orderByTenantId() {
        return (TimerJobQuery)this.orderBy(JobQueryProperty.TENANT_ID);
    }

    public long executeCount(CommandContext commandContext) {
        this.checkQueryOk();
        return CommandContextUtil.getTimerJobEntityManager(commandContext).findJobCountByQueryCriteria(this);
    }

    public List<Job> executeList(CommandContext commandContext) {
        this.checkQueryOk();
        return CommandContextUtil.getTimerJobEntityManager(commandContext).findJobsByQueryCriteria(this);
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public String getExecutionId() {
        return this.executionId;
    }

    public String getHandlerType() {
        return this.handlerType;
    }

    public boolean getExecutable() {
        return this.executable;
    }

    public Date getNow() {
        return CommandContextUtil.getJobServiceConfiguration().getClock().getCurrentTime();
    }

    public boolean isWithException() {
        return this.withException;
    }

    public String getExceptionMessage() {
        return this.exceptionMessage;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getTenantIdLike() {
        return this.tenantIdLike;
    }

    public boolean isWithoutTenantId() {
        return this.withoutTenantId;
    }

    public static long getSerialversionuid() {
        return 1L;
    }

    public String getId() {
        return this.id;
    }

    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public boolean isOnlyTimers() {
        return this.onlyTimers;
    }

    public boolean isOnlyMessages() {
        return this.onlyMessages;
    }

    public Date getDuedateHigherThan() {
        return this.duedateHigherThan;
    }

    public Date getDuedateLowerThan() {
        return this.duedateLowerThan;
    }

    public Date getDuedateHigherThanOrEqual() {
        return this.duedateHigherThanOrEqual;
    }

    public Date getDuedateLowerThanOrEqual() {
        return this.duedateLowerThanOrEqual;
    }
}

