/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.idm.rest.service.api.privilege;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.idm.api.IdmIdentityService;
import org.flowable.idm.api.Privilege;
import org.flowable.idm.rest.service.api.IdmRestApiInterceptor;
import org.flowable.idm.rest.service.api.IdmRestResponseFactory;
import org.flowable.idm.rest.service.api.privilege.PrivilegeResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Privileges"}, description="Manage Privileges", authorizations={@Authorization(value="basicAuth")})
public class PrivilegeResource {
    @Autowired
    protected IdmRestResponseFactory restResponseFactory;
    @Autowired
    protected IdmIdentityService identityService;
    @Autowired(required=false)
    protected IdmRestApiInterceptor restApiInterceptor;

    @ApiOperation(value="Get a single privilege", tags={"Privileges"})
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates the privilege exists and is returned."), @ApiResponse(code=404, message="Indicates the requested privilege does not exist.")})
    @GetMapping(value={"/privileges/{privilegeId}"}, produces={"application/json"})
    public PrivilegeResponse getUser(@ApiParam(name="privilegeId") @PathVariable String privilegeId, HttpServletRequest request) {
        Privilege privilege = (Privilege)this.identityService.createPrivilegeQuery().privilegeId(privilegeId).singleResult();
        if (privilege == null) {
            throw new FlowableObjectNotFoundException("Could not find privilege with id " + privilegeId, Privilege.class);
        }
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.accessPrivilegeInfoById(privilege);
        }
        List users = this.identityService.getUsersWithPrivilege(privilege.getId());
        List groups = this.identityService.getGroupsWithPrivilege(privilege.getId());
        return this.restResponseFactory.createPrivilegeResponse(privilege, users, groups);
    }
}

