/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.http.common.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.api.variable.VariableContainer;

public abstract class ExpressionUtils {
    private ExpressionUtils() {
        throw new RuntimeException("Instantiation not supported");
    }

    public static int getIntFromField(Expression expression, VariableContainer execution) {
        Object value;
        if (expression != null && (value = expression.getValue(execution)) != null) {
            return Integer.parseInt(value.toString());
        }
        return 0;
    }

    public static boolean getBooleanFromField(Expression expression, VariableContainer execution) {
        if (expression != null) {
            Object value = expression.getValue(execution);
            return ExpressionUtils.parseBoolean(value);
        }
        return false;
    }

    protected static boolean parseBoolean(Object value) {
        if (value != null) {
            if (value instanceof String) {
                String stringValue = (String)value;
                if ("true".equalsIgnoreCase(stringValue) || "false".equalsIgnoreCase(stringValue)) {
                    return Boolean.parseBoolean(value.toString());
                }
                throw new FlowableException("String value \"" + value + "\" is not allowed in boolean expression");
            }
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            throw new FlowableException("Value \"" + value + "\" can not be converted into boolean");
        }
        return false;
    }

    public static String getStringFromField(Expression expression, VariableContainer execution) {
        Object value;
        if (expression != null && (value = expression.getValue(execution)) != null) {
            return value.toString();
        }
        return null;
    }

    public static Set<String> getStringSetFromField(String field) {
        String[] codes = field.split("\\s*,\\s*");
        HashSet<String> codeSet = new HashSet<String>(Arrays.asList(codes));
        Collections.addAll(codeSet, codes);
        return codeSet;
    }
}

