/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.form.rest.service.api.repository;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.flowable.common.engine.api.query.Query;
import org.flowable.common.engine.api.query.QueryProperty;
import org.flowable.common.rest.api.DataResponse;
import org.flowable.common.rest.api.PaginateListUtil;
import org.flowable.form.api.FormDefinitionQuery;
import org.flowable.form.api.FormRepositoryService;
import org.flowable.form.engine.impl.FormQueryProperty;
import org.flowable.form.rest.FormRestApiInterceptor;
import org.flowable.form.rest.FormRestResponseFactory;
import org.flowable.form.rest.service.api.repository.FormDefinitionResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Form Definitions"}, description="Manage Form Definitions", authorizations={@Authorization(value="basicAuth")})
public class FormDefinitionCollectionResource {
    private static final Map<String, QueryProperty> properties = new HashMap<String, QueryProperty>();
    @Autowired
    protected FormRestResponseFactory formRestResponseFactory;
    @Autowired
    protected FormRepositoryService formRepositoryService;
    @Autowired(required=false)
    protected FormRestApiInterceptor restApiInterceptor;

    @ApiOperation(value="List of form definitions", nickname="listFormDefinitions", tags={"Form Definitions"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="category", dataType="string", value="Only return form definitions with the given category.", paramType="query"), @ApiImplicitParam(name="categoryLike", dataType="string", value="Only return form definitions with a category like the given value.", paramType="query"), @ApiImplicitParam(name="categoryNotEquals", dataType="string", value="Only return form definitions not with the given category.", paramType="query"), @ApiImplicitParam(name="key", dataType="string", value="Only return form definitions with the given key.", paramType="query"), @ApiImplicitParam(name="keyLike", dataType="string", value="Only return form definitions with a key like the given value.", paramType="query"), @ApiImplicitParam(name="name", dataType="string", value="Only return form definitions with the given name.", paramType="query"), @ApiImplicitParam(name="nameLike", dataType="string", value="Only return form definitions with a name like the given value.", paramType="query"), @ApiImplicitParam(name="resourceName", dataType="string", value="Only return form definitions with the given resource name.", paramType="query"), @ApiImplicitParam(name="resourceNameLike", dataType="string", value="Only return form definitions a resource name like the given value.", paramType="query"), @ApiImplicitParam(name="version", dataType="string", value="Only return form definitions with the given version.", paramType="query"), @ApiImplicitParam(name="versionGreaterThan", dataType="string", value="Only return form definitions with a version greater than the given value.", paramType="query"), @ApiImplicitParam(name="versionGreaterThanOrEquals", dataType="string", value="Only return form definitions with a version greater than or equal to the given value.", paramType="query"), @ApiImplicitParam(name="versionLowerThan", dataType="string", value="Only return form definitions with a version lower than the given value.", paramType="query"), @ApiImplicitParam(name="versionLowerThanOrEquals", dataType="string", value="Only return form definitions with a version lower than or equal to the given value.", paramType="query"), @ApiImplicitParam(name="deploymentId", dataType="string", value="Only return form definitions with the given deployment id.", paramType="query"), @ApiImplicitParam(name="tenantId", dataType="string", value="Only return form definitions with the given tenant id.", paramType="query"), @ApiImplicitParam(name="tenantIdLike", dataType="string", value="Only return form definitions with a tenant id like the given value.", paramType="query"), @ApiImplicitParam(name="withoutTenantId", dataType="string", value="Only return form definitions without a tenant id.", paramType="query"), @ApiImplicitParam(name="latest", dataType="boolean", value="If true; only the latest versions will be returned.", paramType="query"), @ApiImplicitParam(name="sort", dataType="string", value="Property to sort on, to be used together with the order.", allowableValues="key,category,id,version,name,deploymentId,tenantId", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates request was successful and the form definitions are returned"), @ApiResponse(code=400, message="Indicates a parameter was passed in the wrong format . The status-message contains additional information.")})
    @GetMapping(value={"/form-repository/form-definitions"}, produces={"application/json"})
    public DataResponse<FormDefinitionResponse> getForms(@ApiParam(hidden=true) @RequestParam Map<String, String> allRequestParams, HttpServletRequest request) {
        Boolean latest;
        Boolean withoutTenantId;
        FormDefinitionQuery formDefinitionQuery = this.formRepositoryService.createFormDefinitionQuery();
        if (allRequestParams.containsKey("category")) {
            formDefinitionQuery.formCategory(allRequestParams.get("category"));
        }
        if (allRequestParams.containsKey("categoryLike")) {
            formDefinitionQuery.formCategoryLike(allRequestParams.get("categoryLike"));
        }
        if (allRequestParams.containsKey("categoryNotEquals")) {
            formDefinitionQuery.formCategoryNotEquals(allRequestParams.get("categoryNotEquals"));
        }
        if (allRequestParams.containsKey("key")) {
            formDefinitionQuery.formDefinitionKey(allRequestParams.get("key"));
        }
        if (allRequestParams.containsKey("keyLike")) {
            formDefinitionQuery.formDefinitionKeyLike(allRequestParams.get("keyLike"));
        }
        if (allRequestParams.containsKey("name")) {
            formDefinitionQuery.formName(allRequestParams.get("name"));
        }
        if (allRequestParams.containsKey("nameLike")) {
            formDefinitionQuery.formNameLike(allRequestParams.get("nameLike"));
        }
        if (allRequestParams.containsKey("resourceName")) {
            formDefinitionQuery.formResourceName(allRequestParams.get("resourceName"));
        }
        if (allRequestParams.containsKey("resourceNameLike")) {
            formDefinitionQuery.formResourceNameLike(allRequestParams.get("resourceNameLike"));
        }
        if (allRequestParams.containsKey("version")) {
            formDefinitionQuery.formVersion(Integer.valueOf(allRequestParams.get("version")));
        }
        if (allRequestParams.containsKey("versionGreaterThan")) {
            formDefinitionQuery.formVersionGreaterThan(Integer.valueOf(allRequestParams.get("versionGreaterThan")));
        }
        if (allRequestParams.containsKey("versionGreaterThanOrEquals")) {
            formDefinitionQuery.formVersionGreaterThanOrEquals(Integer.valueOf(allRequestParams.get("versionGreaterThanOrEquals")));
        }
        if (allRequestParams.containsKey("versionLowerThan")) {
            formDefinitionQuery.formVersionLowerThan(Integer.valueOf(allRequestParams.get("versionLowerThan")));
        }
        if (allRequestParams.containsKey("versionLowerThanOrEquals")) {
            formDefinitionQuery.formVersionLowerThanOrEquals(Integer.valueOf(allRequestParams.get("versionLowerThanOrEquals")));
        }
        if (allRequestParams.containsKey("deploymentId")) {
            formDefinitionQuery.deploymentId(allRequestParams.get("deploymentId"));
        }
        if (allRequestParams.containsKey("tenantId")) {
            formDefinitionQuery.formTenantId(allRequestParams.get("tenantId"));
        }
        if (allRequestParams.containsKey("tenantIdLike")) {
            formDefinitionQuery.formTenantIdLike(allRequestParams.get("tenantIdLike"));
        }
        if (allRequestParams.containsKey("withoutTenantId") && (withoutTenantId = Boolean.valueOf(allRequestParams.get("withoutTenantId"))).booleanValue()) {
            formDefinitionQuery.formWithoutTenantId();
        }
        if (allRequestParams.containsKey("latest") && (latest = Boolean.valueOf(allRequestParams.get("latest"))).booleanValue()) {
            formDefinitionQuery.latestVersion();
        }
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.accessFormDefinitionInfoWithQuery(formDefinitionQuery);
        }
        return PaginateListUtil.paginateList(allRequestParams, (Query)formDefinitionQuery, (String)"name", properties, this.formRestResponseFactory::createFormResponseList);
    }

    static {
        properties.put("id", (QueryProperty)FormQueryProperty.FORM_ID);
        properties.put("key", (QueryProperty)FormQueryProperty.FORM_DEFINITION_KEY);
        properties.put("category", (QueryProperty)FormQueryProperty.FORM_CATEGORY);
        properties.put("name", (QueryProperty)FormQueryProperty.FORM_NAME);
        properties.put("version", (QueryProperty)FormQueryProperty.FORM_VERSION);
        properties.put("deploymentId", (QueryProperty)FormQueryProperty.DEPLOYMENT_ID);
        properties.put("tenantId", (QueryProperty)FormQueryProperty.FORM_TENANT_ID);
    }
}

