/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.external.job.rest.service.api.acquire;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.Duration;

@ApiModel(description="Request that is used for acquiring external worker jobs")
public class AcquireExternalWorkerJobRequest {
    @ApiModelProperty(value="Acquire jobs with the given topic", example="order", required=true)
    protected String topic;
    @ApiModelProperty(value="The acquired jobs will be locked with this lock duration. ISO-8601 duration format PnDTnHnMn.nS with days considered to be exactly 24 hours.", example="PT10M", dataType="string", required=true)
    protected Duration lockDuration;
    @ApiModelProperty(value="The number of tasks that should be acquired. Default is 1.", example="1")
    protected int numberOfTasks = 1;
    @ApiModelProperty(value="The number of retries if an optimistic lock exception occurs during acquiring. Default is 5", example="10")
    protected int numberOfRetries = 5;
    @ApiModelProperty(value="The id of the external worker that would be used for locking the job", example="orderWorker1", required=true)
    protected String workerId;
    @ApiModelProperty(value="Only acquire jobs with the given scope type", example="cmmn")
    protected String scopeType;

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public Duration getLockDuration() {
        return this.lockDuration;
    }

    public void setLockDuration(Duration lockDuration) {
        this.lockDuration = lockDuration;
    }

    public int getNumberOfTasks() {
        return this.numberOfTasks;
    }

    public void setNumberOfTasks(int numberOfTasks) {
        this.numberOfTasks = numberOfTasks;
    }

    public int getNumberOfRetries() {
        return this.numberOfRetries;
    }

    public void setNumberOfRetries(int numberOfRetries) {
        this.numberOfRetries = numberOfRetries;
    }

    public String getWorkerId() {
        return this.workerId;
    }

    public void setWorkerId(String workerId) {
        this.workerId = workerId;
    }

    public String getScopeType() {
        return this.scopeType;
    }

    public void setScopeType(String scopeType) {
        this.scopeType = scopeType;
    }
}

