/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventsubscription.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.query.CacheAwareQuery;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.interceptor.CommandExecutor;
import org.flowable.common.engine.impl.query.AbstractQuery;
import org.flowable.eventsubscription.api.EventSubscription;
import org.flowable.eventsubscription.api.EventSubscriptionQuery;
import org.flowable.eventsubscription.service.EventSubscriptionServiceConfiguration;
import org.flowable.eventsubscription.service.impl.EventSubscriptionQueryProperty;
import org.flowable.eventsubscription.service.impl.persistence.entity.EventSubscriptionEntity;

public class EventSubscriptionQueryImpl
extends AbstractQuery<EventSubscriptionQuery, EventSubscription>
implements EventSubscriptionQuery,
CacheAwareQuery<EventSubscriptionEntity> {
    private static final long serialVersionUID = 1L;
    protected EventSubscriptionServiceConfiguration eventSubscriptionServiceConfiguration;
    protected String id;
    protected String eventType;
    protected String eventName;
    protected String executionId;
    protected String processInstanceId;
    protected boolean withoutProcessInstanceId;
    protected String processDefinitionId;
    protected boolean withoutProcessDefinitionId;
    protected String activityId;
    protected String subScopeId;
    protected String scopeId;
    protected boolean withoutScopeId;
    protected String scopeDefinitionId;
    protected boolean withoutScopeDefinitionId;
    protected String scopeType;
    protected Date createdBefore;
    protected Date createdAfter;
    protected String tenantId;
    protected Collection<String> tenantIds;
    protected boolean withoutTenantId;
    protected String configuration;
    protected Collection<String> configurations;
    protected boolean withoutConfiguration;
    protected List<EventSubscriptionQueryImpl> orQueryObjects = new ArrayList<EventSubscriptionQueryImpl>();
    protected EventSubscriptionQueryImpl currentOrQueryObject;
    protected boolean inOrStatement;

    public EventSubscriptionQueryImpl() {
    }

    public EventSubscriptionQueryImpl(CommandContext commandContext, EventSubscriptionServiceConfiguration eventSubscriptionServiceConfiguration) {
        super(commandContext);
        this.eventSubscriptionServiceConfiguration = eventSubscriptionServiceConfiguration;
    }

    public EventSubscriptionQueryImpl(CommandExecutor commandExecutor, EventSubscriptionServiceConfiguration eventSubscriptionServiceConfiguration) {
        super(commandExecutor);
        this.eventSubscriptionServiceConfiguration = eventSubscriptionServiceConfiguration;
    }

    public EventSubscriptionQueryImpl id(String id) {
        if (id == null) {
            throw new FlowableIllegalArgumentException("Provided event subscription id is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.id = id;
        } else {
            this.id = id;
        }
        return this;
    }

    public EventSubscriptionQueryImpl eventType(String eventType) {
        if (eventType == null) {
            throw new FlowableIllegalArgumentException("Provided event type is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.eventType = eventType;
        } else {
            this.eventType = eventType;
        }
        return this;
    }

    public EventSubscriptionQueryImpl eventName(String eventName) {
        if (eventName == null) {
            throw new FlowableIllegalArgumentException("Provided event name is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.eventName = eventName;
        } else {
            this.eventName = eventName;
        }
        return this;
    }

    public EventSubscriptionQueryImpl executionId(String executionId) {
        if (executionId == null) {
            throw new FlowableIllegalArgumentException("Provided execution id is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.executionId = executionId;
        } else {
            this.executionId = executionId;
        }
        return this;
    }

    public EventSubscriptionQueryImpl processInstanceId(String processInstanceId) {
        if (processInstanceId == null) {
            throw new FlowableIllegalArgumentException("Provided process instance id is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.processInstanceId = processInstanceId;
        } else {
            this.processInstanceId = processInstanceId;
        }
        return this;
    }

    public EventSubscriptionQueryImpl withoutProcessInstanceId() {
        if (this.inOrStatement) {
            this.currentOrQueryObject.withoutProcessInstanceId = true;
        } else {
            this.withoutProcessInstanceId = true;
        }
        return this;
    }

    public EventSubscriptionQueryImpl processDefinitionId(String processDefinitionId) {
        if (processDefinitionId == null) {
            throw new FlowableIllegalArgumentException("Provided process definition id is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.processDefinitionId = processDefinitionId;
        } else {
            this.processDefinitionId = processDefinitionId;
        }
        return this;
    }

    public EventSubscriptionQueryImpl withoutProcessDefinitionId() {
        if (this.inOrStatement) {
            this.currentOrQueryObject.withoutProcessDefinitionId = true;
        } else {
            this.withoutProcessDefinitionId = true;
        }
        return this;
    }

    public EventSubscriptionQueryImpl activityId(String activityId) {
        if (activityId == null) {
            throw new FlowableIllegalArgumentException("Provided activity id is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.activityId = activityId;
        } else {
            this.activityId = activityId;
        }
        return this;
    }

    public EventSubscriptionQueryImpl caseInstanceId(String caseInstanceId) {
        if (caseInstanceId == null) {
            throw new FlowableIllegalArgumentException("Provided case instance id is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.scopeId = caseInstanceId;
            this.currentOrQueryObject.scopeType = "cmmn";
        } else {
            this.scopeId = caseInstanceId;
            this.scopeType = "cmmn";
        }
        return this;
    }

    public EventSubscriptionQueryImpl planItemInstanceId(String planItemInstanceId) {
        if (planItemInstanceId == null) {
            throw new FlowableIllegalArgumentException("Provided plan item instance id is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.subScopeId = planItemInstanceId;
            this.currentOrQueryObject.scopeType = "cmmn";
        } else {
            this.subScopeId = planItemInstanceId;
            this.scopeType = "cmmn";
        }
        return this;
    }

    public EventSubscriptionQueryImpl caseDefinitionId(String caseDefinitionId) {
        if (caseDefinitionId == null) {
            throw new FlowableIllegalArgumentException("Provided case definition id is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.scopeDefinitionId = caseDefinitionId;
            this.currentOrQueryObject.scopeType = "cmmn";
        } else {
            this.scopeDefinitionId = caseDefinitionId;
            this.scopeType = "cmmn";
        }
        return this;
    }

    public EventSubscriptionQueryImpl subScopeId(String subScopeId) {
        if (subScopeId == null) {
            throw new FlowableIllegalArgumentException("Provided sub scope id is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.subScopeId = subScopeId;
        } else {
            this.subScopeId = subScopeId;
        }
        return this;
    }

    public EventSubscriptionQueryImpl scopeId(String scopeId) {
        if (scopeId == null) {
            throw new FlowableIllegalArgumentException("Provided scope id is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.scopeId = scopeId;
        } else {
            this.scopeId = scopeId;
        }
        return this;
    }

    public EventSubscriptionQueryImpl withoutScopeId() {
        if (this.inOrStatement) {
            this.currentOrQueryObject.withoutScopeId = true;
        } else {
            this.withoutScopeId = true;
        }
        return this;
    }

    public EventSubscriptionQueryImpl scopeDefinitionId(String scopeDefinitionId) {
        if (scopeDefinitionId == null) {
            throw new FlowableIllegalArgumentException("Provided scope definition id is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.scopeDefinitionId = scopeDefinitionId;
        } else {
            this.scopeDefinitionId = scopeDefinitionId;
        }
        return this;
    }

    public EventSubscriptionQueryImpl withoutScopeDefinitionId() {
        if (this.inOrStatement) {
            this.currentOrQueryObject.withoutScopeDefinitionId = true;
        } else {
            this.withoutScopeDefinitionId = true;
        }
        return this;
    }

    public EventSubscriptionQueryImpl scopeType(String scopeType) {
        if (scopeType == null) {
            throw new FlowableIllegalArgumentException("Provided scope type is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.scopeType = scopeType;
        } else {
            this.scopeType = scopeType;
        }
        return this;
    }

    public EventSubscriptionQueryImpl createdBefore(Date beforeTime) {
        if (beforeTime == null) {
            throw new FlowableIllegalArgumentException("created before time is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.createdBefore = beforeTime;
        } else {
            this.createdBefore = beforeTime;
        }
        return this;
    }

    public EventSubscriptionQueryImpl createdAfter(Date afterTime) {
        if (afterTime == null) {
            throw new FlowableIllegalArgumentException("created after time is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.createdAfter = afterTime;
        } else {
            this.createdAfter = afterTime;
        }
        return this;
    }

    public EventSubscriptionQueryImpl tenantId(String tenantId) {
        if (tenantId == null) {
            throw new FlowableIllegalArgumentException("tenant id is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.tenantId = tenantId;
        } else {
            this.tenantId = tenantId;
        }
        return this;
    }

    public EventSubscriptionQuery tenantIds(Collection<String> tenantIds) {
        if (tenantIds == null) {
            throw new FlowableIllegalArgumentException("tenant ids is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.tenantIds = tenantIds;
        } else {
            this.tenantIds = tenantIds;
        }
        return this;
    }

    public EventSubscriptionQuery withoutTenantId() {
        if (this.inOrStatement) {
            this.currentOrQueryObject.withoutTenantId = true;
        } else {
            this.withoutTenantId = true;
        }
        return this;
    }

    public EventSubscriptionQueryImpl configuration(String configuration) {
        if (configuration == null) {
            throw new FlowableIllegalArgumentException("configuration is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.configuration = configuration;
        } else {
            this.configuration = configuration;
        }
        return this;
    }

    public EventSubscriptionQueryImpl configurations(Collection<String> configurations) {
        if (configurations == null) {
            throw new FlowableIllegalArgumentException("configurations are null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.configurations = configurations;
        } else {
            this.configurations = configurations;
        }
        return this;
    }

    public EventSubscriptionQueryImpl withoutConfiguration() {
        if (this.inOrStatement) {
            this.currentOrQueryObject.withoutConfiguration = true;
        } else {
            this.withoutConfiguration = true;
        }
        return this;
    }

    public EventSubscriptionQuery or() {
        if (this.inOrStatement) {
            throw new FlowableException("the query is already in an or statement");
        }
        this.inOrStatement = true;
        this.currentOrQueryObject = new EventSubscriptionQueryImpl();
        this.orQueryObjects.add(this.currentOrQueryObject);
        return this;
    }

    public EventSubscriptionQuery endOr() {
        if (!this.inOrStatement) {
            throw new FlowableException("endOr() can only be called after calling or()");
        }
        this.inOrStatement = false;
        this.currentOrQueryObject = null;
        return this;
    }

    public EventSubscriptionQuery orderById() {
        return (EventSubscriptionQuery)this.orderBy(EventSubscriptionQueryProperty.ID);
    }

    public EventSubscriptionQuery orderByExecutionId() {
        return (EventSubscriptionQuery)this.orderBy(EventSubscriptionQueryProperty.EXECUTION_ID);
    }

    public EventSubscriptionQuery orderByProcessInstanceId() {
        return (EventSubscriptionQuery)this.orderBy(EventSubscriptionQueryProperty.PROCESS_INSTANCE_ID);
    }

    public EventSubscriptionQuery orderByProcessDefinitionId() {
        return (EventSubscriptionQuery)this.orderBy(EventSubscriptionQueryProperty.PROCESS_DEFINITION_ID);
    }

    public EventSubscriptionQuery orderByCreateDate() {
        return (EventSubscriptionQuery)this.orderBy(EventSubscriptionQueryProperty.CREATED);
    }

    public EventSubscriptionQuery orderByEventName() {
        return (EventSubscriptionQuery)this.orderBy(EventSubscriptionQueryProperty.EVENT_NAME);
    }

    public EventSubscriptionQuery orderByTenantId() {
        return (EventSubscriptionQuery)this.orderBy(EventSubscriptionQueryProperty.TENANT_ID);
    }

    public long executeCount(CommandContext commandContext) {
        return this.eventSubscriptionServiceConfiguration.getEventSubscriptionEntityManager().findEventSubscriptionCountByQueryCriteria(this);
    }

    public List<EventSubscription> executeList(CommandContext commandContext) {
        return this.eventSubscriptionServiceConfiguration.getEventSubscriptionEntityManager().findEventSubscriptionsByQueryCriteria(this);
    }

    public String getId() {
        return this.id;
    }

    public String getEventType() {
        return this.eventType;
    }

    public String getEventName() {
        return this.eventName;
    }

    public String getExecutionId() {
        return this.executionId;
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public boolean isWithoutProcessInstanceId() {
        return this.withoutProcessInstanceId;
    }

    public String getActivityId() {
        return this.activityId;
    }

    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public boolean isWithoutProcessDefinitionId() {
        return this.withoutProcessDefinitionId;
    }

    public String getSubScopeId() {
        return this.subScopeId;
    }

    public String getScopeId() {
        return this.scopeId;
    }

    public boolean isWithoutScopeId() {
        return this.withoutScopeId;
    }

    public String getScopeDefinitionId() {
        return this.scopeDefinitionId;
    }

    public boolean isWithoutScopeDefinitionId() {
        return this.withoutScopeDefinitionId;
    }

    public String getScopeType() {
        return this.scopeType;
    }

    public Date getCreatedBefore() {
        return this.createdBefore;
    }

    public Date getCreatedAfter() {
        return this.createdAfter;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public Collection<String> getTenantIds() {
        return this.tenantIds;
    }

    public boolean isWithoutTenantId() {
        return this.withoutTenantId;
    }

    public String getConfiguration() {
        return this.configuration;
    }

    public Collection<String> getConfigurations() {
        return this.configurations;
    }

    public boolean isWithoutConfiguration() {
        return this.withoutConfiguration;
    }

    public List<EventSubscriptionQueryImpl> getOrQueryObjects() {
        return this.orQueryObjects;
    }

    public EventSubscriptionQueryImpl getCurrentOrQueryObject() {
        return this.currentOrQueryObject;
    }

    public boolean isInOrStatement() {
        return this.inOrStatement;
    }
}

