/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.rest.service.api.repository;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.flowable.eventregistry.api.EventDeployment;
import org.flowable.eventregistry.rest.service.api.EventRegistryRestResponseFactory;
import org.flowable.eventregistry.rest.service.api.repository.BaseDeploymentResource;
import org.flowable.eventregistry.rest.service.api.repository.EventDeploymentResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Event Deployment"}, description="Manage Event Deployment", authorizations={@Authorization(value="basicAuth")})
public class DeploymentResource
extends BaseDeploymentResource {
    @Autowired
    protected EventRegistryRestResponseFactory restResponseFactory;

    @ApiOperation(value="Get a deployment", tags={"Deployment"})
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates the deployment was found and returned."), @ApiResponse(code=404, message="Indicates the requested deployment was not found.")})
    @GetMapping(value={"/event-registry-repository/deployments/{deploymentId}"}, produces={"application/json"})
    public EventDeploymentResponse getDeployment(@ApiParam(name="deploymentId", value="The id of the deployment to get.") @PathVariable String deploymentId, HttpServletRequest request) {
        EventDeployment deployment = this.getEventDeployment(deploymentId);
        return this.restResponseFactory.createDeploymentResponse(deployment);
    }

    @ApiOperation(value="Delete a deployment", tags={"Deployment"})
    @ApiResponses(value={@ApiResponse(code=204, message="Indicates the deployment was found and has been deleted. Response-body is intentionally empty."), @ApiResponse(code=404, message="Indicates the requested deployment was not found.")})
    @DeleteMapping(value={"/event-registry-repository/deployments/{deploymentId}"})
    public void deleteDeployment(@ApiParam(name="deploymentId") @PathVariable String deploymentId, HttpServletResponse response) {
        EventDeployment deployment = this.getEventDeployment(deploymentId);
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.deleteDeployment(deployment);
        }
        this.repositoryService.deleteDeployment(deploymentId);
        response.setStatus(HttpStatus.NO_CONTENT.value());
    }
}

