/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.util;

import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.BoundaryEvent;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.Event;
import org.flowable.bpmn.model.ExtensionElement;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.IntermediateCatchEvent;
import org.flowable.bpmn.model.TimerEventDefinition;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.api.delegate.event.FlowableEngineEventType;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.common.engine.api.delegate.event.FlowableEventDispatcher;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.calendar.BusinessCalendar;
import org.flowable.common.engine.impl.el.ExpressionManager;
import org.flowable.common.engine.impl.runtime.Clock;
import org.flowable.engine.delegate.event.impl.FlowableEventBuilder;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.jobexecutor.TimerEventHandler;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.ProcessDefinitionUtil;
import org.flowable.job.api.Job;
import org.flowable.job.service.TimerJobService;
import org.flowable.job.service.event.impl.FlowableJobEventBuilder;
import org.flowable.job.service.impl.persistence.entity.TimerJobEntity;
import org.flowable.variable.service.impl.el.NoExecutionVariableScope;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class TimerUtil {
    public static TimerJobEntity createTimerEntityForTimerEventDefinition(TimerEventDefinition timerEventDefinition, FlowElement currentFlowElement, boolean isInterruptingTimer, ExecutionEntity executionEntity, String jobHandlerType, String jobHandlerConfig) {
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration();
        String businessCalendarRef = null;
        Expression expression = null;
        ExpressionManager expressionManager = processEngineConfiguration.getExpressionManager();
        ExecutionEntity scopeForExpression = executionEntity;
        if (scopeForExpression == null) {
            scopeForExpression = NoExecutionVariableScope.getSharedInstance();
        }
        if (StringUtils.isNotEmpty((CharSequence)timerEventDefinition.getTimeDate())) {
            businessCalendarRef = "dueDate";
            expression = expressionManager.createExpression(timerEventDefinition.getTimeDate());
        } else if (StringUtils.isNotEmpty((CharSequence)timerEventDefinition.getTimeCycle())) {
            businessCalendarRef = "cycle";
            expression = expressionManager.createExpression(timerEventDefinition.getTimeCycle());
        } else if (StringUtils.isNotEmpty((CharSequence)timerEventDefinition.getTimeDuration())) {
            businessCalendarRef = "duration";
            expression = expressionManager.createExpression(timerEventDefinition.getTimeDuration());
        }
        if (StringUtils.isNotEmpty((CharSequence)timerEventDefinition.getCalendarName())) {
            businessCalendarRef = timerEventDefinition.getCalendarName();
            Expression businessCalendarExpression = expressionManager.createExpression(businessCalendarRef);
            businessCalendarRef = businessCalendarExpression.getValue((VariableContainer)scopeForExpression).toString();
        }
        if (expression == null) {
            throw new FlowableException("Timer needs configuration (either timeDate, timeCycle or timeDuration is needed) (" + timerEventDefinition.getId() + ")");
        }
        BusinessCalendar businessCalendar = processEngineConfiguration.getBusinessCalendarManager().getBusinessCalendar(businessCalendarRef);
        String dueDateString = null;
        Date duedate = null;
        Object dueDateValue = expression.getValue((VariableContainer)scopeForExpression);
        if (dueDateValue instanceof String) {
            dueDateString = (String)dueDateValue;
        } else if (dueDateValue instanceof Date) {
            duedate = (Date)dueDateValue;
        } else if (dueDateValue instanceof DateTime) {
            duedate = ((DateTime)dueDateValue).toDate();
        } else if (dueDateValue instanceof Duration) {
            dueDateString = ((Duration)dueDateValue).toString();
        } else if (dueDateValue instanceof Instant) {
            duedate = Date.from((Instant)dueDateValue);
        } else if (dueDateValue instanceof LocalDate) {
            duedate = Date.from(((LocalDate)dueDateValue).atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
        } else if (dueDateValue instanceof LocalDateTime) {
            duedate = Date.from(((LocalDateTime)dueDateValue).atZone(ZoneId.systemDefault()).toInstant());
        } else if (dueDateValue != null) {
            throw new FlowableException("Timer '" + executionEntity.getActivityId() + "' in " + executionEntity + " was not configured with a valid duration/time, either hand in a java.util.Date, java.time.LocalDate, java.time.LocalDateTime or a java.time.Instant or a org.joda.time.DateTime or a String in format 'yyyy-MM-dd'T'hh:mm:ss'");
        }
        if (duedate == null && dueDateString != null) {
            duedate = businessCalendar.resolveDuedate(dueDateString);
        }
        TimerJobEntity timer = null;
        if (duedate != null) {
            ExtensionElement jobCategoryElement;
            String jobCategoryElementText = null;
            List jobCategoryElements = (List)currentFlowElement.getExtensionElements().get("jobCategory");
            if (jobCategoryElements != null && jobCategoryElements.size() > 0 && StringUtils.isNotEmpty((CharSequence)(jobCategoryElement = (ExtensionElement)jobCategoryElements.get(0)).getElementText())) {
                jobCategoryElementText = jobCategoryElement.getElementText();
            }
            timer = processEngineConfiguration.getJobServiceConfiguration().getTimerJobService().createTimerJob();
            timer.setJobType("timer");
            timer.setRevision(1);
            timer.setJobHandlerType(jobHandlerType);
            timer.setJobHandlerConfiguration(jobHandlerConfig);
            timer.setExclusive(true);
            timer.setRetries(processEngineConfiguration.getAsyncExecutorNumberOfRetries());
            timer.setDuedate(duedate);
            if (executionEntity != null) {
                Expression categoryExpression;
                Object categoryValue;
                timer.setExecutionId(executionEntity.getId());
                timer.setProcessDefinitionId(executionEntity.getProcessDefinitionId());
                timer.setProcessInstanceId(executionEntity.getProcessInstanceId());
                if (executionEntity.getTenantId() != null) {
                    timer.setTenantId(executionEntity.getTenantId());
                }
                if (jobCategoryElementText != null && (categoryValue = (categoryExpression = processEngineConfiguration.getExpressionManager().createExpression(jobCategoryElementText)).getValue((VariableContainer)executionEntity)) != null) {
                    timer.setCategory(categoryValue.toString());
                }
            } else if (jobCategoryElementText != null) {
                timer.setCategory(jobCategoryElementText);
            }
        } else {
            throw new FlowableException("Due date could not be determined for timer job " + dueDateString);
        }
        if (StringUtils.isNotEmpty((CharSequence)timerEventDefinition.getTimeCycle())) {
            FlowElement currentElement;
            boolean repeat;
            boolean bl = repeat = !isInterruptingTimer;
            if (executionEntity != null && (currentElement = executionEntity.getCurrentFlowElement()) instanceof IntermediateCatchEvent) {
                repeat = false;
            }
            if (repeat) {
                String prepared = TimerUtil.prepareRepeat(dueDateString);
                timer.setRepeat(prepared);
            }
        }
        if (timer != null && executionEntity != null) {
            timer.setExecutionId(executionEntity.getId());
            timer.setProcessDefinitionId(executionEntity.getProcessDefinitionId());
            timer.setProcessInstanceId(executionEntity.getProcessInstanceId());
            timer.setElementId(executionEntity.getCurrentFlowElement().getId());
            timer.setElementName(executionEntity.getCurrentFlowElement().getName());
            if (executionEntity.getTenantId() != null) {
                timer.setTenantId(executionEntity.getTenantId());
            }
        }
        return timer;
    }

    public static TimerJobEntity rescheduleTimerJob(String timerJobId, TimerEventDefinition timerEventDefinition) {
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration();
        TimerJobService timerJobService = processEngineConfiguration.getJobServiceConfiguration().getTimerJobService();
        TimerJobEntity timerJob = timerJobService.findTimerJobById(timerJobId);
        if (timerJob != null) {
            BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(timerJob.getProcessDefinitionId());
            Event eventElement = (Event)bpmnModel.getFlowElement(TimerEventHandler.getActivityIdFromConfiguration(timerJob.getJobHandlerConfiguration()));
            boolean isInterruptingTimer = false;
            if (eventElement instanceof BoundaryEvent) {
                isInterruptingTimer = ((BoundaryEvent)eventElement).isCancelActivity();
            }
            ExecutionEntity execution = (ExecutionEntity)processEngineConfiguration.getExecutionEntityManager().findById(timerJob.getExecutionId());
            TimerJobEntity rescheduledTimerJob = TimerUtil.createTimerEntityForTimerEventDefinition(timerEventDefinition, (FlowElement)eventElement, isInterruptingTimer, execution, timerJob.getJobHandlerType(), timerJob.getJobHandlerConfiguration());
            timerJobService.deleteTimerJob(timerJob);
            timerJobService.insertTimerJob(rescheduledTimerJob);
            FlowableEventDispatcher eventDispatcher = processEngineConfiguration.getEventDispatcher();
            if (eventDispatcher != null && eventDispatcher.isEnabled()) {
                eventDispatcher.dispatchEvent((FlowableEvent)FlowableEventBuilder.createJobRescheduledEvent(FlowableEngineEventType.JOB_RESCHEDULED, (Job)rescheduledTimerJob, timerJob.getId()), processEngineConfiguration.getEngineCfgKey());
                eventDispatcher.dispatchEvent((FlowableEvent)FlowableJobEventBuilder.createEntityEvent((FlowableEngineEventType)FlowableEngineEventType.TIMER_SCHEDULED, (Object)rescheduledTimerJob), processEngineConfiguration.getEngineCfgKey());
            }
            return rescheduledTimerJob;
        }
        return null;
    }

    public static String prepareRepeat(String dueDate) {
        if (dueDate.startsWith("R") && dueDate.split("/").length == 2) {
            DateTimeFormatter fmt = ISODateTimeFormat.dateTime();
            Clock clock = CommandContextUtil.getProcessEngineConfiguration().getClock();
            Date now = clock.getCurrentTime();
            return dueDate.replace("/", "/" + fmt.print((ReadableInstant)new DateTime((Object)now, DateTimeZone.forTimeZone((TimeZone)clock.getCurrentTimeZone()))) + "/");
        }
        return dueDate;
    }
}

