/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.jobexecutor;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import org.flowable.engine.impl.util.CommandContextUtil;

public class TimerEventHandler {
    public static final String PROPERTYNAME_TIMER_ACTIVITY_ID = "activityId";
    public static final String PROPERTYNAME_END_DATE_EXPRESSION = "timerEndDate";
    public static final String PROPERTYNAME_CALENDAR_NAME_EXPRESSION = "calendarName";

    public static String createConfiguration(String id, String endDate, String calendarName) {
        ObjectNode cfgJson = TimerEventHandler.createObjectNode();
        cfgJson.put(PROPERTYNAME_TIMER_ACTIVITY_ID, id);
        if (endDate != null) {
            cfgJson.put(PROPERTYNAME_END_DATE_EXPRESSION, endDate);
        }
        if (calendarName != null) {
            cfgJson.put(PROPERTYNAME_CALENDAR_NAME_EXPRESSION, calendarName);
        }
        return cfgJson.toString();
    }

    public static String setActivityIdToConfiguration(String jobHandlerConfiguration, String activityId) {
        try {
            ObjectNode cfgJson = TimerEventHandler.readJsonValueAsObjectNode(jobHandlerConfiguration);
            cfgJson.put(PROPERTYNAME_TIMER_ACTIVITY_ID, activityId);
            return cfgJson.toString();
        }
        catch (IOException ex) {
            return jobHandlerConfiguration;
        }
    }

    public static String getActivityIdFromConfiguration(String jobHandlerConfiguration) {
        try {
            JsonNode cfgJson = TimerEventHandler.readJsonValue(jobHandlerConfiguration);
            JsonNode activityIdNode = cfgJson.get(PROPERTYNAME_TIMER_ACTIVITY_ID);
            if (activityIdNode != null) {
                return activityIdNode.asText();
            }
            return jobHandlerConfiguration;
        }
        catch (IOException ex) {
            return jobHandlerConfiguration;
        }
    }

    public static String getCalendarNameFromConfiguration(String jobHandlerConfiguration) {
        try {
            JsonNode cfgJson = TimerEventHandler.readJsonValue(jobHandlerConfiguration);
            JsonNode calendarNameNode = cfgJson.get(PROPERTYNAME_CALENDAR_NAME_EXPRESSION);
            if (calendarNameNode != null) {
                return calendarNameNode.asText();
            }
            return "";
        }
        catch (IOException ex) {
            return "";
        }
    }

    public static String setEndDateToConfiguration(String jobHandlerConfiguration, String endDate) {
        ObjectNode cfgJson = null;
        try {
            cfgJson = TimerEventHandler.readJsonValueAsObjectNode(jobHandlerConfiguration);
        }
        catch (IOException ex) {
            cfgJson = TimerEventHandler.createObjectNode();
            cfgJson.put(PROPERTYNAME_TIMER_ACTIVITY_ID, jobHandlerConfiguration);
        }
        if (endDate != null) {
            cfgJson.put(PROPERTYNAME_END_DATE_EXPRESSION, endDate);
        }
        return cfgJson.toString();
    }

    public static String getEndDateFromConfiguration(String jobHandlerConfiguration) {
        try {
            JsonNode cfgJson = TimerEventHandler.readJsonValue(jobHandlerConfiguration);
            JsonNode endDateNode = cfgJson.get(PROPERTYNAME_END_DATE_EXPRESSION);
            if (endDateNode != null) {
                return endDateNode.asText();
            }
            return null;
        }
        catch (IOException ex) {
            return null;
        }
    }

    protected static ObjectNode createObjectNode() {
        return CommandContextUtil.getProcessEngineConfiguration().getObjectMapper().createObjectNode();
    }

    protected static ObjectNode readJsonValueAsObjectNode(String config) throws IOException {
        return (ObjectNode)TimerEventHandler.readJsonValue(config);
    }

    protected static JsonNode readJsonValue(String config) throws IOException {
        if (CommandContextUtil.getCommandContext() != null) {
            return CommandContextUtil.getProcessEngineConfiguration().getObjectMapper().readTree(config);
        }
        return new ObjectMapper().readTree(config);
    }
}

