/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.history.async.json.transformer;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.flowable.common.engine.api.delegate.event.FlowableEngineEventType;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.delegate.event.impl.FlowableEventBuilder;
import org.flowable.engine.impl.history.async.json.transformer.AbstractNeedsProcessInstanceHistoryJsonTransformer;
import org.flowable.engine.impl.persistence.entity.HistoricProcessInstanceEntity;
import org.flowable.engine.impl.persistence.entity.HistoricProcessInstanceEntityManager;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.job.service.impl.history.async.util.AsyncHistoryJsonUtil;
import org.flowable.job.service.impl.persistence.entity.HistoryJobEntity;

public class ProcessInstanceEndHistoryJsonTransformer
extends AbstractNeedsProcessInstanceHistoryJsonTransformer {
    public List<String> getTypes() {
        return Collections.singletonList("process-instance-end");
    }

    public void transformJson(HistoryJobEntity job, ObjectNode historicalData, CommandContext commandContext) {
        String processInstanceId;
        HistoricProcessInstanceEntityManager historicProcessInstanceEntityManager = CommandContextUtil.getHistoricProcessInstanceEntityManager(commandContext);
        HistoricProcessInstanceEntity historicProcessInstance = (HistoricProcessInstanceEntity)historicProcessInstanceEntityManager.findById(processInstanceId = AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"processInstanceId"));
        if (historicProcessInstance != null) {
            historicProcessInstance.setEndActivityId(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"activityId"));
            Date endTime = AsyncHistoryJsonUtil.getDateFromJson((ObjectNode)historicalData, (String)"endTime");
            historicProcessInstance.setEndTime(endTime);
            historicProcessInstance.setDeleteReason(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"deleteReason"));
            Date startTime = historicProcessInstance.getStartTime();
            if (startTime != null && endTime != null) {
                historicProcessInstance.setDurationInMillis(endTime.getTime() - startTime.getTime());
            }
            this.dispatchEvent(commandContext, (FlowableEvent)FlowableEventBuilder.createEntityEvent(FlowableEngineEventType.HISTORIC_PROCESS_INSTANCE_ENDED, historicProcessInstance));
        } else {
            historicProcessInstance = historicProcessInstanceEntityManager.create();
            historicProcessInstance.setId(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"id"));
            historicProcessInstance.setProcessInstanceId(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"processInstanceId"));
            historicProcessInstance.setBusinessKey(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"businessKey"));
            historicProcessInstance.setProcessDefinitionId(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"processDefinitionId"));
            historicProcessInstance.setProcessDefinitionKey(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"processDefinitionKey"));
            historicProcessInstance.setProcessDefinitionName(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"processDefinitionName"));
            String versionString = AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"processDefinitionVersion");
            historicProcessInstance.setProcessDefinitionVersion(versionString != null ? Integer.valueOf(versionString) : 0);
            historicProcessInstance.setDeploymentId(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"deploymentId"));
            historicProcessInstance.setStartTime(AsyncHistoryJsonUtil.getDateFromJson((ObjectNode)historicalData, (String)"startTime"));
            historicProcessInstance.setStartUserId(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"startUserId"));
            historicProcessInstance.setStartActivityId(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"startActivityId"));
            historicProcessInstance.setSuperProcessInstanceId(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"superProcessInstanceId"));
            historicProcessInstance.setCallbackId(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"callbackId"));
            historicProcessInstance.setCallbackType(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"callbackType"));
            historicProcessInstance.setTenantId(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"tenantId"));
            historicProcessInstanceEntityManager.insert(historicProcessInstance, false);
            this.dispatchEvent(commandContext, (FlowableEvent)FlowableEventBuilder.createEntityEvent(FlowableEngineEventType.HISTORIC_PROCESS_INSTANCE_CREATED, historicProcessInstance));
            historicProcessInstance.setEndActivityId(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"activityId"));
            Date endTime = AsyncHistoryJsonUtil.getDateFromJson((ObjectNode)historicalData, (String)"endTime");
            historicProcessInstance.setEndTime(endTime);
            historicProcessInstance.setDeleteReason(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"deleteReason"));
            Date startTime = historicProcessInstance.getStartTime();
            if (startTime != null && endTime != null) {
                historicProcessInstance.setDurationInMillis(endTime.getTime() - startTime.getTime());
            }
            historicProcessInstanceEntityManager.update(historicProcessInstance, false);
            this.dispatchEvent(commandContext, (FlowableEvent)FlowableEventBuilder.createEntityEvent(FlowableEngineEventType.HISTORIC_PROCESS_INSTANCE_ENDED, historicProcessInstance));
        }
    }
}

