/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.bpmn.parser.handler;

import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.CancelEventDefinition;
import org.flowable.bpmn.model.EndEvent;
import org.flowable.bpmn.model.ErrorEventDefinition;
import org.flowable.bpmn.model.EventDefinition;
import org.flowable.bpmn.model.TerminateEventDefinition;
import org.flowable.engine.impl.bpmn.parser.BpmnParse;
import org.flowable.engine.impl.bpmn.parser.handler.AbstractActivityBpmnParseHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EndEventParseHandler
extends AbstractActivityBpmnParseHandler<EndEvent> {
    private static final Logger LOGGER = LoggerFactory.getLogger(EndEventParseHandler.class);

    @Override
    public Class<? extends BaseElement> getHandledType() {
        return EndEvent.class;
    }

    @Override
    protected void executeParse(BpmnParse bpmnParse, EndEvent endEvent) {
        EventDefinition eventDefinition = null;
        if (endEvent.getEventDefinitions().size() > 0) {
            eventDefinition = (EventDefinition)endEvent.getEventDefinitions().get(0);
            if (eventDefinition instanceof ErrorEventDefinition) {
                String errorCode;
                ErrorEventDefinition errorDefinition = (ErrorEventDefinition)eventDefinition;
                if (bpmnParse.getBpmnModel().containsErrorRef(errorDefinition.getErrorCode()) && StringUtils.isEmpty((CharSequence)(errorCode = (String)bpmnParse.getBpmnModel().getErrors().get(errorDefinition.getErrorCode())))) {
                    LOGGER.warn("errorCode is required for an error event {}", (Object)endEvent.getId());
                }
                endEvent.setBehavior((Object)bpmnParse.getActivityBehaviorFactory().createErrorEndEventActivityBehavior(endEvent, errorDefinition));
            } else if (eventDefinition instanceof TerminateEventDefinition) {
                endEvent.setBehavior((Object)bpmnParse.getActivityBehaviorFactory().createTerminateEndEventActivityBehavior(endEvent));
            } else if (eventDefinition instanceof CancelEventDefinition) {
                endEvent.setBehavior((Object)bpmnParse.getActivityBehaviorFactory().createCancelEndEventActivityBehavior(endEvent));
            } else {
                endEvent.setBehavior((Object)bpmnParse.getActivityBehaviorFactory().createNoneEndEventActivityBehavior(endEvent));
            }
        } else {
            endEvent.setBehavior((Object)bpmnParse.getActivityBehaviorFactory().createNoneEndEventActivityBehavior(endEvent));
        }
    }
}

