/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl;

import java.util.List;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.impl.AbstractQuery;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.interceptor.CommandExecutor;
import org.flowable.engine.impl.ActivityInstanceQueryProperty;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.runtime.ActivityInstance;
import org.flowable.engine.runtime.ActivityInstanceQuery;

public class ActivityInstanceQueryImpl
extends AbstractQuery<ActivityInstanceQuery, ActivityInstance>
implements ActivityInstanceQuery {
    private static final long serialVersionUID = 1L;
    protected String activityInstanceId;
    protected String processInstanceId;
    protected String executionId;
    protected String processDefinitionId;
    protected String activityId;
    protected String activityName;
    protected String activityType;
    protected String assignee;
    protected String tenantId;
    protected String tenantIdLike;
    protected boolean withoutTenantId;
    protected boolean finished;
    protected boolean unfinished;
    protected String deleteReason;
    protected String deleteReasonLike;

    public ActivityInstanceQueryImpl() {
    }

    public ActivityInstanceQueryImpl(CommandContext commandContext) {
        super(commandContext);
    }

    public ActivityInstanceQueryImpl(CommandExecutor commandExecutor) {
        super(commandExecutor);
    }

    public long executeCount(CommandContext commandContext) {
        this.checkQueryOk();
        return CommandContextUtil.getActivityInstanceEntityManager(commandContext).findActivityInstanceCountByQueryCriteria(this);
    }

    public List<ActivityInstance> executeList(CommandContext commandContext) {
        this.checkQueryOk();
        return CommandContextUtil.getActivityInstanceEntityManager(commandContext).findActivityInstancesByQueryCriteria(this);
    }

    @Override
    public ActivityInstanceQueryImpl processInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
        return this;
    }

    @Override
    public ActivityInstanceQueryImpl executionId(String executionId) {
        this.executionId = executionId;
        return this;
    }

    @Override
    public ActivityInstanceQueryImpl processDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
        return this;
    }

    @Override
    public ActivityInstanceQueryImpl activityId(String activityId) {
        this.activityId = activityId;
        return this;
    }

    @Override
    public ActivityInstanceQueryImpl activityName(String activityName) {
        this.activityName = activityName;
        return this;
    }

    @Override
    public ActivityInstanceQueryImpl activityType(String activityType) {
        this.activityType = activityType;
        return this;
    }

    @Override
    public ActivityInstanceQueryImpl taskAssignee(String assignee) {
        this.assignee = assignee;
        return this;
    }

    @Override
    public ActivityInstanceQueryImpl finished() {
        this.finished = true;
        this.unfinished = false;
        return this;
    }

    @Override
    public ActivityInstanceQueryImpl unfinished() {
        this.unfinished = true;
        this.finished = false;
        return this;
    }

    @Override
    public ActivityInstanceQuery deleteReason(String deleteReason) {
        this.deleteReason = deleteReason;
        return this;
    }

    @Override
    public ActivityInstanceQuery deleteReasonLike(String deleteReasonLike) {
        this.deleteReasonLike = deleteReasonLike;
        return this;
    }

    @Override
    public ActivityInstanceQueryImpl activityTenantId(String tenantId) {
        if (tenantId == null) {
            throw new FlowableIllegalArgumentException("activity tenant id is null");
        }
        this.tenantId = tenantId;
        return this;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public ActivityInstanceQueryImpl activityTenantIdLike(String tenantIdLike) {
        if (tenantIdLike == null) {
            throw new FlowableIllegalArgumentException("activity tenant id is null");
        }
        this.tenantIdLike = tenantIdLike;
        return this;
    }

    public String getTenantIdLike() {
        return this.tenantIdLike;
    }

    @Override
    public ActivityInstanceQueryImpl activityWithoutTenantId() {
        this.withoutTenantId = true;
        return this;
    }

    public boolean isWithoutTenantId() {
        return this.withoutTenantId;
    }

    @Override
    public ActivityInstanceQueryImpl orderByActivityInstanceDuration() {
        this.orderBy(ActivityInstanceQueryProperty.DURATION);
        return this;
    }

    @Override
    public ActivityInstanceQueryImpl orderByActivityInstanceEndTime() {
        this.orderBy(ActivityInstanceQueryProperty.END);
        return this;
    }

    @Override
    public ActivityInstanceQueryImpl orderByExecutionId() {
        this.orderBy(ActivityInstanceQueryProperty.EXECUTION_ID);
        return this;
    }

    @Override
    public ActivityInstanceQueryImpl orderByActivityInstanceId() {
        this.orderBy(ActivityInstanceQueryProperty.ACTIVITY_INSTANCE_ID);
        return this;
    }

    @Override
    public ActivityInstanceQueryImpl orderByProcessDefinitionId() {
        this.orderBy(ActivityInstanceQueryProperty.PROCESS_DEFINITION_ID);
        return this;
    }

    @Override
    public ActivityInstanceQueryImpl orderByProcessInstanceId() {
        this.orderBy(ActivityInstanceQueryProperty.PROCESS_INSTANCE_ID);
        return this;
    }

    @Override
    public ActivityInstanceQueryImpl orderByActivityInstanceStartTime() {
        this.orderBy(ActivityInstanceQueryProperty.START);
        return this;
    }

    @Override
    public ActivityInstanceQuery orderByActivityId() {
        this.orderBy(ActivityInstanceQueryProperty.ACTIVITY_ID);
        return this;
    }

    @Override
    public ActivityInstanceQueryImpl orderByActivityName() {
        this.orderBy(ActivityInstanceQueryProperty.ACTIVITY_NAME);
        return this;
    }

    @Override
    public ActivityInstanceQueryImpl orderByActivityType() {
        this.orderBy(ActivityInstanceQueryProperty.ACTIVITY_TYPE);
        return this;
    }

    @Override
    public ActivityInstanceQueryImpl orderByTenantId() {
        this.orderBy(ActivityInstanceQueryProperty.TENANT_ID);
        return this;
    }

    @Override
    public ActivityInstanceQueryImpl activityInstanceId(String activityInstanceId) {
        this.activityInstanceId = activityInstanceId;
        return this;
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public String getExecutionId() {
        return this.executionId;
    }

    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public String getActivityId() {
        return this.activityId;
    }

    public String getActivityName() {
        return this.activityName;
    }

    public String getActivityType() {
        return this.activityType;
    }

    public String getAssignee() {
        return this.assignee;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public boolean isUnfinished() {
        return this.unfinished;
    }

    public String getActivityInstanceId() {
        return this.activityInstanceId;
    }

    public String getDeleteReason() {
        return this.deleteReason;
    }

    public String getDeleteReasonLike() {
        return this.deleteReasonLike;
    }
}

