/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.engine.impl.util.io;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.flowable.common.engine.impl.util.io.StreamSource;

public class StringStreamSource
implements StreamSource {
    protected final String string;
    protected final Charset byteArrayEncoding;

    public StringStreamSource(String string) {
        this(string, StandardCharsets.UTF_8);
    }

    public StringStreamSource(String string, String byteArrayEncoding) {
        this.string = string;
        this.byteArrayEncoding = Charset.forName(byteArrayEncoding);
    }

    public StringStreamSource(String string, Charset byteArrayEncoding) {
        this.string = string;
        this.byteArrayEncoding = byteArrayEncoding;
    }

    @Override
    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.byteArrayEncoding == null ? this.string.getBytes() : this.string.getBytes(this.byteArrayEncoding));
    }

    public String toString() {
        return "String";
    }
}

