/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.engine.impl.cfg;

import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import org.flowable.common.engine.impl.AbstractEngineConfiguration;
import org.flowable.common.engine.impl.cfg.SpringBeanFactoryProxyMap;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;

public class BeansConfigurationHelper {
    public static AbstractEngineConfiguration parseEngineConfiguration(Resource springResource, String beanName) {
        DefaultListableBeanFactory beanFactory = new DefaultListableBeanFactory();
        XmlBeanDefinitionReader xmlBeanDefinitionReader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)beanFactory);
        xmlBeanDefinitionReader.setValidationMode(3);
        xmlBeanDefinitionReader.loadBeanDefinitions(springResource);
        Collection factoryPostProcessors = beanFactory.getBeansOfType(BeanFactoryPostProcessor.class, true, false).values();
        if (factoryPostProcessors.isEmpty()) {
            factoryPostProcessors = Collections.singleton(new PropertyPlaceholderConfigurer());
        }
        for (BeanFactoryPostProcessor factoryPostProcessor : factoryPostProcessors) {
            factoryPostProcessor.postProcessBeanFactory((ConfigurableListableBeanFactory)beanFactory);
        }
        AbstractEngineConfiguration engineConfiguration = (AbstractEngineConfiguration)beanFactory.getBean(beanName);
        engineConfiguration.setBeans(new SpringBeanFactoryProxyMap((BeanFactory)beanFactory));
        return engineConfiguration;
    }

    public static AbstractEngineConfiguration parseEngineConfigurationFromInputStream(InputStream inputStream, String beanName) {
        InputStreamResource springResource = new InputStreamResource(inputStream);
        return BeansConfigurationHelper.parseEngineConfiguration((Resource)springResource, beanName);
    }

    public static AbstractEngineConfiguration parseEngineConfigurationFromResource(String resource, String beanName) {
        ClassPathResource springResource = new ClassPathResource(resource);
        return BeansConfigurationHelper.parseEngineConfiguration((Resource)springResource, beanName);
    }
}

