/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.engine.impl.scripting;

import java.util.ArrayList;
import java.util.List;
import javax.script.Bindings;
import org.flowable.common.engine.impl.AbstractEngineConfiguration;
import org.flowable.common.engine.impl.scripting.Resolver;
import org.flowable.common.engine.impl.scripting.ResolverFactory;
import org.flowable.common.engine.impl.scripting.ScriptBindings;
import org.flowable.common.engine.impl.scripting.ScriptEngineRequest;

public class ScriptBindingsFactory {
    protected AbstractEngineConfiguration engineConfiguration;
    protected List<ResolverFactory> resolverFactories;

    public ScriptBindingsFactory(AbstractEngineConfiguration engineConfiguration, List<ResolverFactory> resolverFactories) {
        this.engineConfiguration = engineConfiguration;
        this.resolverFactories = resolverFactories;
    }

    public Bindings createBindings(ScriptEngineRequest request) {
        return new ScriptBindings(this.createResolvers(request), request.getVariableContainer(), request.isStoreScriptVariables());
    }

    protected List<Resolver> createResolvers(ScriptEngineRequest request) {
        ArrayList<Resolver> scriptResolvers = new ArrayList<Resolver>();
        scriptResolvers.addAll(request.getAdditionalResolvers());
        for (ResolverFactory scriptResolverFactory : this.resolverFactories) {
            Resolver resolver = scriptResolverFactory.createResolver(this.engineConfiguration, request.getVariableContainer());
            if (resolver == null) continue;
            scriptResolvers.add(resolver);
        }
        return scriptResolvers;
    }

    public List<ResolverFactory> getResolverFactories() {
        return this.resolverFactories;
    }

    public void setResolverFactories(List<ResolverFactory> resolverFactories) {
        this.resolverFactories = resolverFactories;
    }
}

