/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.engine.impl.persistence.entity;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import org.flowable.common.engine.impl.AbstractEngineConfiguration;
import org.flowable.common.engine.impl.context.Context;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.interceptor.CommandExecutor;
import org.flowable.common.engine.impl.persistence.entity.ByteArrayEntity;
import org.flowable.common.engine.impl.persistence.entity.ByteArrayEntityManager;

public class ByteArrayRef
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected CommandExecutor commandExecutor;
    private String id;
    private String name;
    private ByteArrayEntity entity;
    protected boolean deleted;

    public ByteArrayRef() {
    }

    public ByteArrayRef(String id, CommandExecutor commandExecutor) {
        this.id = id;
        this.commandExecutor = commandExecutor;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public byte[] getBytes(String engineType) {
        this.ensureInitialized(engineType);
        return this.entity != null ? this.entity.getBytes() : null;
    }

    public String asString(String engineType) {
        byte[] bytes = this.getBytes(engineType);
        if (bytes == null) {
            return null;
        }
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public void setValue(String name, byte[] bytes, String engineType) {
        this.name = name;
        this.setBytes(bytes, engineType);
    }

    public void setValue(String name, String value, String engineType) {
        this.name = name;
        if (value != null) {
            this.setBytes(value.getBytes(StandardCharsets.UTF_8), engineType);
        }
    }

    protected void setBytes(byte[] bytes, String engineType) {
        if (this.id == null) {
            if (bytes != null) {
                AbstractEngineConfiguration engineConfiguration = this.getEngineConfiguration(engineType);
                ByteArrayEntityManager byteArrayEntityManager = engineConfiguration.getByteArrayEntityManager();
                this.entity = (ByteArrayEntity)byteArrayEntityManager.create();
                this.entity.setName(this.name);
                this.entity.setBytes(bytes);
                byteArrayEntityManager.insert(this.entity);
                this.id = this.entity.getId();
                this.deleted = false;
            }
        } else {
            this.ensureInitialized(engineType);
            if (bytes != null) {
                this.entity.setBytes(bytes);
            } else {
                this.delete(engineType);
            }
        }
    }

    public ByteArrayEntity getEntity(String engineType) {
        this.ensureInitialized(engineType);
        return this.entity;
    }

    public void delete(String engineType) {
        if (!this.deleted && this.id != null) {
            if (this.entity != null) {
                this.getEngineConfiguration(engineType).getByteArrayEntityManager().delete(this.entity);
            } else {
                this.getEngineConfiguration(engineType).getByteArrayEntityManager().deleteByteArrayById(this.id);
            }
            this.entity = null;
            this.id = null;
            this.deleted = true;
        }
    }

    protected void ensureInitialized(String engineType) {
        if (this.id != null && this.entity == null) {
            CommandContext commandContext = Context.getCommandContext();
            if (commandContext != null) {
                this.entity = (ByteArrayEntity)this.getEngineConfiguration(engineType).getByteArrayEntityManager().findById(this.id);
            } else if (this.commandExecutor != null) {
                this.entity = this.commandExecutor.execute(context -> (ByteArrayEntity)this.getEngineConfiguration(engineType).getByteArrayEntityManager().findById(this.id));
            } else {
                throw new IllegalStateException("Cannot initialize byte array. There is no command context and there is no command Executor");
            }
            if (this.entity != null) {
                this.name = this.entity.getName();
            }
        }
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public ByteArrayRef copy() {
        ByteArrayRef copy = new ByteArrayRef();
        copy.id = this.id;
        copy.name = this.name;
        copy.entity = this.entity;
        copy.deleted = this.deleted;
        return copy;
    }

    protected AbstractEngineConfiguration getEngineConfiguration(String engineType) {
        CommandContext commandContext = Context.getCommandContext();
        if (commandContext != null) {
            return this.getEngineConfiguration(engineType, commandContext);
        }
        if (this.commandExecutor != null) {
            return this.commandExecutor.execute(context -> this.getEngineConfiguration(engineType, context));
        }
        throw new IllegalStateException("Cannot initialize byte array. There is no command context and there is no command Executor");
    }

    protected AbstractEngineConfiguration getEngineConfiguration(String engineType, CommandContext commandContext) {
        if ("all".equalsIgnoreCase(engineType)) {
            return this.getEngineConfigurationForAllType(commandContext);
        }
        AbstractEngineConfiguration engineConfiguration = commandContext.getEngineConfigurations().get(engineType);
        if (engineConfiguration == null) {
            engineConfiguration = this.getFirstEngineConfigurationWithByteArrayEntityManager(commandContext);
        }
        return engineConfiguration;
    }

    protected AbstractEngineConfiguration getEngineConfigurationForAllType(CommandContext commandContext) {
        AbstractEngineConfiguration engineConfiguration = commandContext.getEngineConfigurations().get("bpmn");
        if (engineConfiguration == null && (engineConfiguration = commandContext.getEngineConfigurations().get("cmmn")) == null) {
            engineConfiguration = this.getFirstEngineConfigurationWithByteArrayEntityManager(commandContext);
        }
        if (engineConfiguration == null) {
            throw new IllegalStateException("Cannot initialize byte array. No engine configuration found");
        }
        return engineConfiguration;
    }

    protected AbstractEngineConfiguration getFirstEngineConfigurationWithByteArrayEntityManager(CommandContext commandContext) {
        AbstractEngineConfiguration engineConfiguration = null;
        for (AbstractEngineConfiguration possibleEngineConfiguration : commandContext.getEngineConfigurations().values()) {
            if (possibleEngineConfiguration.getByteArrayEntityManager() == null) continue;
            engineConfiguration = possibleEngineConfiguration;
            break;
        }
        if (engineConfiguration == null) {
            throw new IllegalStateException("Cannot initialize byte array. No engine configuration found");
        }
        return engineConfiguration;
    }

    public String toString() {
        return "ByteArrayRef[id=" + this.id + ", name=" + this.name + ", entity=" + this.entity + (this.deleted ? ", deleted]" : "]");
    }
}

