/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.engine.impl.agenda;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.agenda.Agenda;
import org.flowable.common.engine.impl.agenda.ExecuteFutureActionOperation;
import org.flowable.common.engine.impl.agenda.WaitForAnyFutureToFinishOperation;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAgenda
implements Agenda {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractAgenda.class);
    protected CommandContext commandContext;
    protected LinkedList<Runnable> operations = new LinkedList();
    protected List<ExecuteFutureActionOperation<?>> futureOperations = new ArrayList();

    public AbstractAgenda(CommandContext commandContext) {
        this.commandContext = commandContext;
    }

    @Override
    public boolean isEmpty() {
        return this.operations.isEmpty() && this.futureOperations.isEmpty();
    }

    @Override
    public Runnable getNextOperation() {
        this.assertOperationsNotEmpty();
        if (!this.operations.isEmpty()) {
            return this.operations.poll();
        }
        ArrayList copyOperations = new ArrayList(this.futureOperations);
        this.futureOperations.clear();
        return new WaitForAnyFutureToFinishOperation(this, copyOperations);
    }

    protected void assertOperationsNotEmpty() {
        if (this.operations.isEmpty() && this.futureOperations.isEmpty()) {
            throw new FlowableException("Unable to peek empty agenda.");
        }
    }

    @Override
    public void planOperation(Runnable operation) {
        this.operations.add(operation);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Operation {} added to agenda", operation.getClass());
        }
    }

    @Override
    public <V> void planFutureOperation(CompletableFuture<V> future, BiConsumer<V, Throwable> completeAction) {
        ExecuteFutureActionOperation<V> operation = new ExecuteFutureActionOperation<V>(future, completeAction);
        if (future.isDone()) {
            this.operations.addFirst(operation);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Operation {} added to agenda", operation.getClass());
            }
        } else {
            this.futureOperations.add(operation);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Future {} with action {} added to agenda", future, completeAction.getClass());
            }
        }
    }

    public LinkedList<Runnable> getOperations() {
        return this.operations;
    }

    public CommandContext getCommandContext() {
        return this.commandContext;
    }

    public void setCommandContext(CommandContext commandContext) {
        this.commandContext = commandContext;
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }
}

