/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.engine.impl.deployer;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.repository.EngineDeployment;
import org.flowable.dmn.engine.impl.deployer.DecisionRequirementsDiagramHelper;
import org.flowable.dmn.engine.impl.deployer.ParsedDeployment;
import org.flowable.dmn.engine.impl.deployer.ResourceNameUtil;
import org.flowable.dmn.engine.impl.persistence.entity.DecisionEntity;
import org.flowable.dmn.engine.impl.persistence.entity.DecisionEntityManager;
import org.flowable.dmn.engine.impl.persistence.entity.DmnDeploymentEntity;
import org.flowable.dmn.engine.impl.persistence.entity.DmnResourceEntity;
import org.flowable.dmn.engine.impl.util.CommandContextUtil;

public class DmnDeploymentHelper {
    public void verifyDecisionTablesDoNotShareKeys(Collection<DecisionEntity> decisionTables) {
        LinkedHashSet<String> keySet = new LinkedHashSet<String>();
        for (DecisionEntity decisionTable : decisionTables) {
            if (keySet.contains(decisionTable.getKey())) {
                throw new FlowableException("The deployment contains decisions with the same key (decision id attribute), this is not allowed");
            }
            keySet.add(decisionTable.getKey());
        }
    }

    public void copyDeploymentValuesToDecisions(DmnDeploymentEntity deployment, List<DecisionEntity> decisions) {
        String tenantId = deployment.getTenantId();
        String deploymentId = deployment.getId();
        for (DecisionEntity decision : decisions) {
            if (tenantId != null) {
                decision.setTenantId(tenantId);
            }
            decision.setDeploymentId(deploymentId);
        }
    }

    public void setResourceNamesOnDecisions(ParsedDeployment parsedDeployment) {
        for (DecisionEntity decision : parsedDeployment.getAllDecisions()) {
            String resourceName = parsedDeployment.getResourceForDecision(decision).getName();
            decision.setResourceName(resourceName);
        }
    }

    public DecisionEntity getMostRecentVersionOfDecision(DecisionEntity decision) {
        String key = decision.getKey();
        String tenantId = decision.getTenantId();
        DecisionEntityManager decisionTableEntityManager = CommandContextUtil.getDmnEngineConfiguration().getDecisionEntityManager();
        DecisionEntity existingDecision = tenantId != null && !tenantId.equals("") ? decisionTableEntityManager.findLatestDecisionByKeyAndTenantId(key, tenantId) : decisionTableEntityManager.findLatestDecisionByKey(key);
        return existingDecision;
    }

    public DecisionEntity getPersistedInstanceOfDecision(DecisionEntity decision) {
        String deploymentId = decision.getDeploymentId();
        if (StringUtils.isEmpty((CharSequence)decision.getDeploymentId())) {
            throw new FlowableIllegalArgumentException("Provided decision must have a deployment id.");
        }
        DecisionEntityManager decisionEntityManager = CommandContextUtil.getDmnEngineConfiguration().getDecisionEntityManager();
        DecisionEntity persistedDecision = decision.getTenantId() == null || "".equals(decision.getTenantId()) ? decisionEntityManager.findDecisionByDeploymentAndKey(deploymentId, decision.getKey()) : decisionEntityManager.findDecisionByDeploymentAndKeyAndTenantId(deploymentId, decision.getKey(), decision.getTenantId());
        return persistedDecision;
    }

    public void createAndPersistNewDiagramsIfNeeded(ParsedDeployment parsedDeployment, DecisionRequirementsDiagramHelper decisionRequirementsDiagramHelper) {
        for (DecisionEntity decision : parsedDeployment.getAllDecisions()) {
            DmnResourceEntity resource;
            if (!decisionRequirementsDiagramHelper.shouldCreateDiagram(decision, (EngineDeployment)parsedDeployment.getDeployment()) || (resource = decisionRequirementsDiagramHelper.createDiagramForDecision(decision, parsedDeployment.getDmnDefinitionForDecision(decision))) == null) continue;
            CommandContextUtil.getResourceEntityManager().insert(resource, false);
            parsedDeployment.getDeployment().addResource(resource);
        }
    }

    protected void setDecisionDefinitionDiagramNames(ParsedDeployment parsedDeployment) {
        Map resources = parsedDeployment.getDeployment().getResources();
        for (DecisionEntity decisionDefinition : parsedDeployment.getAllDecisions()) {
            String diagramResourceName = ResourceNameUtil.getDecisionRequirementsDiagramResourceNameFromDeployment(decisionDefinition, resources);
            decisionDefinition.setDiagramResourceName(diagramResourceName);
        }
    }
}

