/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.engine.impl.cmd;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.common.engine.api.repository.EngineResource;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.dmn.api.DmnDeployment;
import org.flowable.dmn.api.DmnDeploymentQuery;
import org.flowable.dmn.engine.DmnEngineConfiguration;
import org.flowable.dmn.engine.impl.DmnDeploymentQueryImpl;
import org.flowable.dmn.engine.impl.persistence.entity.DmnDeploymentEntity;
import org.flowable.dmn.engine.impl.persistence.entity.DmnResourceEntity;
import org.flowable.dmn.engine.impl.repository.DmnDeploymentBuilderImpl;
import org.flowable.dmn.engine.impl.util.CommandContextUtil;

public class DeployCmd<T>
implements Command<DmnDeployment>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected DmnDeploymentBuilderImpl deploymentBuilder;

    public DeployCmd(DmnDeploymentBuilderImpl deploymentBuilder) {
        this.deploymentBuilder = deploymentBuilder;
    }

    public DmnDeployment execute(CommandContext commandContext) {
        DmnDeploymentEntity deployment = this.deploymentBuilder.getDeployment();
        DmnEngineConfiguration dmnEngineConfiguration = CommandContextUtil.getDmnEngineConfiguration(commandContext);
        deployment.setDeploymentTime(dmnEngineConfiguration.getClock().getCurrentTime());
        if (this.deploymentBuilder.isDuplicateFilterEnabled()) {
            ArrayList<DmnDeployment> existingDeployments = new ArrayList<DmnDeployment>();
            if (deployment.getTenantId() == null || "".equals(deployment.getTenantId())) {
                List deploymentEntities = ((DmnDeploymentQuery)new DmnDeploymentQueryImpl(dmnEngineConfiguration.getCommandExecutor()).deploymentName(deployment.getName()).orderByDeploymentTime().desc()).listPage(0, 1);
                if (!deploymentEntities.isEmpty()) {
                    existingDeployments.add((DmnDeployment)deploymentEntities.get(0));
                }
            } else {
                List deploymentList = ((DmnDeploymentQuery)dmnEngineConfiguration.getDmnRepositoryService().createDeploymentQuery().deploymentName(deployment.getName()).deploymentTenantId(deployment.getTenantId()).orderByDeploymentTime().desc()).listPage(0, 1);
                if (!deploymentList.isEmpty()) {
                    existingDeployments.addAll(deploymentList);
                }
            }
            if (!existingDeployments.isEmpty()) {
                DmnDeploymentEntity existingDeployment = (DmnDeploymentEntity)existingDeployments.get(0);
                HashMap<String, EngineResource> resourceMap = new HashMap<String, EngineResource>();
                List<DmnResourceEntity> resourceList = dmnEngineConfiguration.getResourceEntityManager().findResourcesByDeploymentId(existingDeployment.getId());
                for (DmnResourceEntity resourceEntity : resourceList) {
                    resourceMap.put(resourceEntity.getName(), resourceEntity);
                }
                existingDeployment.setResources(resourceMap);
                if (!this.deploymentsDiffer(deployment, existingDeployment)) {
                    return existingDeployment;
                }
            }
        }
        deployment.setNew(true);
        dmnEngineConfiguration.getDeploymentEntityManager().insert(deployment);
        if (StringUtils.isEmpty((CharSequence)deployment.getParentDeploymentId())) {
            deployment.setParentDeploymentId(deployment.getId());
        }
        HashMap<String, Object> deploymentSettings = new HashMap<String, Object>();
        deploymentSettings.put("isDmnXsdValidationEnabled", this.deploymentBuilder.isDmnXsdValidationEnabled());
        dmnEngineConfiguration.getDeploymentManager().deploy(deployment, deploymentSettings);
        return deployment;
    }

    protected boolean deploymentsDiffer(DmnDeploymentEntity deployment, DmnDeploymentEntity saved) {
        if (deployment.getResources() == null || saved.getResources() == null) {
            return true;
        }
        Map resources = deployment.getResources();
        Map savedResources = saved.getResources();
        for (String resourceName : resources.keySet()) {
            byte[] savedBytes;
            EngineResource resource;
            byte[] bytes;
            EngineResource savedResource = (EngineResource)savedResources.get(resourceName);
            if (savedResource == null) {
                return true;
            }
            if (savedResource.isGenerated() || Arrays.equals(bytes = (resource = (EngineResource)resources.get(resourceName)).getBytes(), savedBytes = savedResource.getBytes())) continue;
            return true;
        }
        return false;
    }
}

