/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.engine.impl.agenda.operation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.dmn.api.DecisionExecutionAuditContainer;
import org.flowable.dmn.api.DecisionServiceExecutionAuditContainer;
import org.flowable.dmn.api.ExecuteDecisionContext;
import org.flowable.dmn.engine.impl.agenda.operation.DmnOperation;
import org.flowable.dmn.engine.impl.audit.DecisionExecutionAuditUtil;
import org.flowable.dmn.engine.impl.util.CommandContextUtil;
import org.flowable.dmn.model.Decision;
import org.flowable.dmn.model.DecisionService;
import org.flowable.dmn.model.InformationRequirement;

public class ExecuteDecisionServiceOperation
extends DmnOperation {
    protected final DecisionService decisionService;
    protected final ExecuteDecisionContext executeDecisionContext;

    public ExecuteDecisionServiceOperation(CommandContext commandContext, ExecuteDecisionContext executeDecisionContext, DecisionService decisionService) {
        super(commandContext);
        this.executeDecisionContext = executeDecisionContext;
        this.decisionService = decisionService;
    }

    @Override
    public void run() {
        DecisionServiceExecutionAuditContainer auditContainer = DecisionExecutionAuditUtil.initializeDecisionServiceExecutionAudit(this.decisionService, this.executeDecisionContext);
        this.executeDecisionContext.setDecisionExecution((DecisionExecutionAuditContainer)auditContainer);
        this.planExecuteDecisionOperationsForDecisionService();
    }

    protected void planExecuteDecisionOperationsForDecisionService() {
        List<Decision> encapsulatedDecisions = this.decisionService.getEncapsulatedDecisions().stream().map(ref -> this.decisionService.getDmnDefinition().getDecisionById(ref.getParsedId())).collect(Collectors.toList());
        List<Decision> outputDecisions = this.decisionService.getOutputDecisions().stream().map(ref -> this.decisionService.getDmnDefinition().getDecisionById(ref.getParsedId())).collect(Collectors.toList());
        List<Decision> orderedOutputDecisions = this.determineDecisionExecutionOrder(encapsulatedDecisions, outputDecisions);
        orderedOutputDecisions.forEach(decision -> CommandContextUtil.getAgenda(this.commandContext).planExecuteDecisionOperation(this.executeDecisionContext, (Decision)decision));
    }

    protected List<Decision> determineDecisionExecutionOrder(List<Decision> encapsulatedDecisions, List<Decision> outputDecisions) {
        List<Decision> combinedDecisions = Stream.of(encapsulatedDecisions, outputDecisions).flatMap(Collection::stream).collect(Collectors.toList());
        return this.determineDecisionExecutionOrder(combinedDecisions);
    }

    protected List<Decision> determineDecisionExecutionOrder(List<Decision> allDecisions) {
        ArrayList<Decision> order = new ArrayList<Decision>();
        LinkedList<Decision> sortDecisions = new LinkedList<Decision>();
        HashMap<String, Decision> decisionsById = new HashMap<String, Decision>();
        HashMap<String, Boolean> visited = new HashMap<String, Boolean>();
        for (Decision sortDecision : allDecisions) {
            decisionsById.put(sortDecision.getId(), sortDecision);
            visited.put(sortDecision.getId(), false);
            if (sortDecision.getRequiredDecisions().isEmpty()) {
                sortDecisions.addFirst(sortDecision);
                continue;
            }
            sortDecisions.addLast(sortDecision);
        }
        for (Decision decision : sortDecisions) {
            if (((Boolean)visited.get(decision.getId())).booleanValue()) continue;
            this.executeSort(decisionsById, decision.getId(), visited, order);
        }
        return order;
    }

    private void executeSort(Map<String, Decision> decisions, String decisionId, Map<String, Boolean> visited, List<Decision> order) {
        if (!decisions.containsKey(decisionId)) {
            throw new FlowableObjectNotFoundException("Required decision " + decisionId + " is not available");
        }
        visited.replace(decisionId, true);
        for (InformationRequirement requiredDecision : decisions.get(decisionId).getRequiredDecisions()) {
            if (visited.get(requiredDecision.getRequiredDecision().getParsedId()).booleanValue()) continue;
            this.executeSort(decisions, requiredDecision.getRequiredDecision().getParsedId(), visited, order);
        }
        order.add(decisions.get(decisionId));
    }
}

