/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.content.engine.impl.db;

import javax.sql.DataSource;
import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.ResourceAccessor;
import org.apache.commons.lang3.StringUtils;
import org.flowable.content.engine.ContentEngine;
import org.flowable.content.engine.ContentEngines;

public class DbSchemaDrop {
    public static void main(String[] args) {
        try {
            ContentEngine contentEngine = ContentEngines.getDefaultContentEngine();
            DataSource dataSource = contentEngine.getContentEngineConfiguration().getDataSource();
            JdbcConnection connection = new JdbcConnection(dataSource.getConnection());
            Database database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)connection);
            database.setDatabaseChangeLogTableName("ACT_CO_" + database.getDatabaseChangeLogTableName());
            database.setDatabaseChangeLogLockTableName("ACT_CO_" + database.getDatabaseChangeLogLockTableName());
            if (StringUtils.isNotEmpty((CharSequence)contentEngine.getContentEngineConfiguration().getDatabaseSchema())) {
                database.setDefaultSchemaName(contentEngine.getContentEngineConfiguration().getDatabaseSchema());
                database.setLiquibaseSchemaName(contentEngine.getContentEngineConfiguration().getDatabaseSchema());
            }
            if (StringUtils.isNotEmpty((CharSequence)contentEngine.getContentEngineConfiguration().getDatabaseCatalog())) {
                database.setDefaultCatalogName(contentEngine.getContentEngineConfiguration().getDatabaseCatalog());
                database.setLiquibaseCatalogName(contentEngine.getContentEngineConfiguration().getDatabaseCatalog());
            }
            Liquibase liquibase = new Liquibase("org/flowable/content/db/liquibase/flowable-content-db-changelog.xml", (ResourceAccessor)new ClassLoaderResourceAccessor(), database);
            liquibase.dropAll();
            liquibase.getDatabase().close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

