/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.rest.variable;

import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.rest.variable.EngineRestVariable;
import org.flowable.common.rest.variable.RestVariableConverter;

public class ShortRestVariableConverter
implements RestVariableConverter {
    @Override
    public String getRestTypeName() {
        return "short";
    }

    @Override
    public Class<?> getVariableType() {
        return Short.class;
    }

    @Override
    public Object getVariableValue(EngineRestVariable result) {
        if (result.getValue() != null) {
            if (!(result.getValue() instanceof Number)) {
                throw new FlowableIllegalArgumentException("Converter can only convert shorts");
            }
            return ((Number)result.getValue()).shortValue();
        }
        return null;
    }

    @Override
    public void convertVariableValue(Object variableValue, EngineRestVariable result) {
        if (variableValue != null) {
            if (!(variableValue instanceof Short)) {
                throw new FlowableIllegalArgumentException("Converter can only convert shorts");
            }
            result.setValue(variableValue);
        } else {
            result.setValue(null);
        }
    }
}

