/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.rest.variable;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.Map;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.rest.variable.EngineRestVariable;
import org.flowable.common.rest.variable.RestVariableConverter;

public class JsonObjectRestVariableConverter
implements RestVariableConverter {
    protected ObjectMapper objectMapper;

    public JsonObjectRestVariableConverter(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Override
    public String getRestTypeName() {
        return "json";
    }

    @Override
    public Class<?> getVariableType() {
        return JsonNode.class;
    }

    @Override
    public Object getVariableValue(EngineRestVariable result) {
        if (result.getValue() != null) {
            if (result.getValue() instanceof Map || result.getValue() instanceof List) {
                return this.objectMapper.valueToTree(result.getValue());
            }
            return result.getValue();
        }
        return null;
    }

    @Override
    public void convertVariableValue(Object variableValue, EngineRestVariable result) {
        if (variableValue != null) {
            if (!(variableValue instanceof JsonNode)) {
                throw new FlowableIllegalArgumentException("Converter can only convert com.fasterxml.jackson.databind.JsonNode.");
            }
            result.setValue(variableValue);
        } else {
            result.setValue(null);
        }
    }
}

