/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.rest.service.api.runtime.task;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.flowable.cmmn.rest.service.api.engine.RestIdentityLink;
import org.flowable.cmmn.rest.service.api.runtime.task.TaskBaseResource;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.identitylink.api.IdentityLink;
import org.flowable.task.api.Task;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Task Identity Links"}, description="Manage Tasks", authorizations={@Authorization(value="basicAuth")})
public class TaskIdentityLinkFamilyResource
extends TaskBaseResource {
    @ApiOperation(value="List identity links for a task for either groups or users", tags={"Task Identity Links"}, nickname="listIdentityLinksForFamily", notes="Returns only identity links targeting either users or groups. Response body and status-codes are exactly the same as when getting the full list of identity links for a task.")
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates the task was found and the requested identity links are returned."), @ApiResponse(code=404, message="Indicates the requested task was not found.")})
    @GetMapping(value={"/cmmn-runtime/tasks/{taskId}/identitylinks/{family}"}, produces={"application/json"})
    public List<RestIdentityLink> getIdentityLinksForFamily(@ApiParam(name="taskId") @PathVariable(value="taskId") String taskId, @ApiParam(name="family") @PathVariable(value="family") String family, HttpServletRequest request) {
        Task task = this.getTaskFromRequestWithoutAccessCheck(taskId);
        if (family == null || !"groups".equals(family) && !"users".equals(family)) {
            throw new FlowableIllegalArgumentException("Identity link family should be 'users' or 'groups'.");
        }
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.accessTaskIdentityLinks(task);
        }
        boolean isUser = family.equals("users");
        ArrayList<RestIdentityLink> results = new ArrayList<RestIdentityLink>();
        List allLinks = this.taskService.getIdentityLinksForTask(task.getId());
        for (IdentityLink link : allLinks) {
            boolean match = false;
            if (isUser) {
                match = link.getUserId() != null;
            } else {
                boolean bl = match = link.getGroupId() != null;
            }
            if (!match) continue;
            results.add(this.restResponseFactory.createRestIdentityLink(link));
        }
        return results;
    }
}

