/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.rest.service.api.history.caze;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.flowable.cmmn.api.CmmnHistoryService;
import org.flowable.cmmn.api.history.HistoricCaseInstance;
import org.flowable.cmmn.rest.service.api.CmmnRestResponseFactory;
import org.flowable.cmmn.rest.service.api.history.caze.HistoricCaseInstanceBaseResource;
import org.flowable.cmmn.rest.service.api.history.task.HistoricIdentityLinkResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"History Case"}, description="Manage History Case Instances", authorizations={@Authorization(value="basicAuth")})
public class HistoricCaseInstanceIdentityLinkCollectionResource
extends HistoricCaseInstanceBaseResource {
    @Autowired
    protected CmmnRestResponseFactory restResponseFactory;
    @Autowired
    protected CmmnHistoryService historyService;

    @ApiOperation(value="List identity links of a historic case instance", nickname="listHistoricCaseInstanceIdentityLinks", tags={"History Case"}, notes="")
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates request was successful and the identity links are returned", response=HistoricIdentityLinkResponse.class, responseContainer="List"), @ApiResponse(code=404, message="Indicates the process instance could not be found..")})
    @GetMapping(value={"/cmmn-history/historic-case-instances/{caseInstanceId}/identitylinks"}, produces={"application/json"})
    public List<HistoricIdentityLinkResponse> getCaseIdentityLinks(@ApiParam(name="caseInstanceId") @PathVariable String caseInstanceId, HttpServletRequest request) {
        List identityLinks;
        HistoricCaseInstance caseInstance = this.getHistoricCaseInstanceFromRequestWithoutAccessCheck(caseInstanceId);
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.accessHistoricCaseIdentityLinks(caseInstance);
        }
        if ((identityLinks = this.historyService.getHistoricIdentityLinksForCaseInstance(caseInstance.getId())) != null) {
            return this.restResponseFactory.createHistoricIdentityLinkResponseList(identityLinks);
        }
        return new ArrayList<HistoricIdentityLinkResponse>();
    }
}

