/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.model;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.flowable.cmmn.model.Case;
import org.flowable.cmmn.model.PlanItem;
import org.flowable.cmmn.model.PlanItemDefinition;
import org.flowable.cmmn.model.Sentry;

public class PlanFragment
extends PlanItemDefinition {
    protected Case caze;
    protected PlanItem planItem;
    protected Map<String, PlanItem> planItemMap = new LinkedHashMap<String, PlanItem>();
    protected Map<String, PlanItem> planItemDefinitionToItemMap = new LinkedHashMap<String, PlanItem>();
    protected List<Sentry> sentries = new ArrayList<Sentry>();

    public PlanItem findPlanItemInPlanFragmentOrDownwards(String planItemId) {
        for (PlanItem planItem : this.planItemMap.values()) {
            PlanItem p;
            if (planItem.getId().equals(planItemId)) {
                return planItem;
            }
            if (!(planItem.getPlanItemDefinition() instanceof PlanFragment) || (p = ((PlanFragment)planItem.getPlanItemDefinition()).findPlanItemInPlanFragmentOrDownwards(planItemId)) == null) continue;
            return p;
        }
        return null;
    }

    public PlanItem findPlanItemInPlanFragmentOrUpwards(String planItemId) {
        PlanItem p;
        if (this.planItemMap.containsKey(planItemId)) {
            return this.planItemMap.get(planItemId);
        }
        PlanFragment parentPlanFragment = this.getParent();
        if (parentPlanFragment != null && (p = parentPlanFragment.findPlanItemInPlanFragmentOrUpwards(planItemId)) != null) {
            return p;
        }
        return null;
    }

    public PlanItem findPlanItemForPlanItemDefinitionInPlanFragmentOrUpwards(String planItemDefinitionId) {
        PlanItem p;
        if (this.planItemDefinitionToItemMap.containsKey(planItemDefinitionId)) {
            return this.planItemDefinitionToItemMap.get(planItemDefinitionId);
        }
        PlanFragment parentPlanFragment = this.getParent();
        if (parentPlanFragment != null && (p = parentPlanFragment.findPlanItemForPlanItemDefinitionInPlanFragmentOrUpwards(planItemDefinitionId)) != null) {
            return p;
        }
        return null;
    }

    public PlanItem findPlanItemForPlanItemDefinitionInPlanFragmentOrDownwards(String planItemDefinitionId) {
        if (this.planItemDefinitionToItemMap.containsKey(planItemDefinitionId)) {
            return this.planItemDefinitionToItemMap.get(planItemDefinitionId);
        }
        for (PlanItem planItem : this.planItemMap.values()) {
            PlanItem p;
            if (!(planItem.getPlanItemDefinition() instanceof PlanFragment) || (p = ((PlanFragment)planItem.getPlanItemDefinition()).findPlanItemForPlanItemDefinitionInPlanFragmentOrDownwards(planItemDefinitionId)) == null) continue;
            return p;
        }
        return null;
    }

    public Sentry findSentry(String sentryId) {
        for (Sentry sentry : this.sentries) {
            if (!sentry.getId().equals(sentryId)) continue;
            return sentry;
        }
        PlanFragment parentPlanFragment = this.getParent();
        if (parentPlanFragment != null) {
            return parentPlanFragment.findSentry(sentryId);
        }
        return null;
    }

    public void addPlanItem(PlanItem planItem) {
        this.planItemMap.put(planItem.getId(), planItem);
        this.planItemDefinitionToItemMap.put(planItem.getDefinitionRef(), planItem);
    }

    public void addSentry(Sentry sentry) {
        this.sentries.add(sentry);
    }

    public Case getCase() {
        return this.caze;
    }

    public void setCase(Case caze) {
        this.caze = caze;
    }

    public PlanItem getPlanItem() {
        return this.planItem;
    }

    public void setPlanItem(PlanItem planItem) {
        this.planItem = planItem;
    }

    public List<PlanItem> getPlanItems() {
        return new ArrayList<PlanItem>(this.planItemMap.values());
    }

    public Map<String, PlanItem> getPlanItemMap() {
        return this.planItemMap;
    }

    public void setPlanItemMap(Map<String, PlanItem> planItemMap) {
        this.planItemMap = planItemMap;
    }

    public List<Sentry> getSentries() {
        return this.sentries;
    }

    public void setSentries(List<Sentry> sentries) {
        this.sentries = sentries;
    }
}

