/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.editor.json.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Map;
import org.flowable.cmmn.editor.json.converter.ActivityProcessor;
import org.flowable.cmmn.editor.json.converter.BaseCmmnJsonConverter;
import org.flowable.cmmn.editor.json.converter.CaseModelAwareConverter;
import org.flowable.cmmn.editor.json.converter.CmmnJsonConverter;
import org.flowable.cmmn.editor.json.converter.CmmnJsonConverterUtil;
import org.flowable.cmmn.editor.json.converter.util.ListenerConverterUtil;
import org.flowable.cmmn.model.BaseElement;
import org.flowable.cmmn.model.CaseTask;
import org.flowable.cmmn.model.CmmnModel;
import org.flowable.cmmn.model.PlanItem;
import org.flowable.cmmn.model.PlanItemDefinition;

public class CaseTaskJsonConverter
extends BaseCmmnJsonConverter
implements CaseModelAwareConverter {
    protected Map<String, String> caseModelMap;

    public static void fillTypes(Map<String, Class<? extends BaseCmmnJsonConverter>> convertersToCmmnMap, Map<Class<? extends BaseElement>, Class<? extends BaseCmmnJsonConverter>> convertersToJsonMap) {
        CaseTaskJsonConverter.fillJsonTypes(convertersToCmmnMap);
        CaseTaskJsonConverter.fillCmmnTypes(convertersToJsonMap);
    }

    public static void fillJsonTypes(Map<String, Class<? extends BaseCmmnJsonConverter>> convertersToBpmnMap) {
        convertersToBpmnMap.put("CaseTask", CaseTaskJsonConverter.class);
    }

    public static void fillCmmnTypes(Map<Class<? extends BaseElement>, Class<? extends BaseCmmnJsonConverter>> convertersToJsonMap) {
        convertersToJsonMap.put(CaseTask.class, CaseTaskJsonConverter.class);
    }

    @Override
    protected String getStencilId(BaseElement baseElement) {
        return "CaseTask";
    }

    @Override
    protected void convertElementToJson(ObjectNode elementNode, ObjectNode propertiesNode, ActivityProcessor processor, BaseElement baseElement, CmmnModel cmmnModel) {
        CaseTask caseTask = (CaseTask)((PlanItem)baseElement).getPlanItemDefinition();
        if (caseTask.getFallbackToDefaultTenant() != null) {
            propertiesNode.put("fallbacktodefaulttenant", caseTask.getFallbackToDefaultTenant());
        }
        ListenerConverterUtil.convertLifecycleListenersToJson(this.objectMapper, propertiesNode, (PlanItemDefinition)caseTask);
    }

    @Override
    protected BaseElement convertJsonToElement(JsonNode elementNode, JsonNode modelNode, ActivityProcessor processor, BaseElement parentElement, Map<String, JsonNode> shapeMap, CmmnModel cmmnModel, CmmnJsonConverter.CmmnModelIdHelper cmmnModelIdHelper) {
        boolean fallbackToDefaultTenant;
        CaseTask task = new CaseTask();
        JsonNode caseModelReferenceNode = CmmnJsonConverterUtil.getProperty("casetaskcasereference", elementNode);
        if (caseModelReferenceNode != null && caseModelReferenceNode.has("id") && !caseModelReferenceNode.get("id").isNull()) {
            String caseModelId = caseModelReferenceNode.get("id").asText();
            if (this.caseModelMap != null) {
                String caseModelKey = this.caseModelMap.get(caseModelId);
                task.setCaseRef(caseModelKey);
            }
        }
        if (fallbackToDefaultTenant = CmmnJsonConverterUtil.getPropertyValueAsBoolean("fallbacktodefaulttenant", elementNode, false)) {
            task.setFallbackToDefaultTenant(Boolean.valueOf(true));
        }
        ListenerConverterUtil.convertJsonToLifeCycleListeners(elementNode, (PlanItemDefinition)task);
        return task;
    }

    @Override
    public void setCaseModelMap(Map<String, String> caseModelMap) {
        this.caseModelMap = caseModelMap;
    }
}

