/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.cfg;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseInstanceEntity;
import org.flowable.cmmn.engine.impl.task.TaskHelper;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.cmmn.engine.impl.util.IdentityLinkUtil;
import org.flowable.identitylink.api.IdentityLink;
import org.flowable.identitylink.service.impl.persistence.entity.IdentityLinkEntity;
import org.flowable.task.api.Task;
import org.flowable.task.service.InternalTaskAssignmentManager;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;

public class DefaultTaskAssignmentManager
implements InternalTaskAssignmentManager {
    protected String parentIdentityLinkType;

    public DefaultTaskAssignmentManager() {
        this("participant");
    }

    public DefaultTaskAssignmentManager(String parentIdentityLinkType) {
        this.parentIdentityLinkType = parentIdentityLinkType;
    }

    public void changeAssignee(Task task, String assignee) {
        TaskHelper.changeTaskAssignee((TaskEntity)task, assignee);
    }

    public void changeOwner(Task task, String owner) {
        TaskHelper.changeTaskOwner((TaskEntity)task, owner);
    }

    public void addCandidateUser(Task task, IdentityLink identityLink) {
        IdentityLinkUtil.handleTaskIdentityLinkAddition((TaskEntity)task, (IdentityLinkEntity)identityLink);
    }

    public void addCandidateUsers(Task task, List<IdentityLink> candidateUsers) {
        ArrayList<IdentityLinkEntity> identityLinks = new ArrayList<IdentityLinkEntity>();
        for (IdentityLink identityLink : candidateUsers) {
            identityLinks.add((IdentityLinkEntity)identityLink);
        }
        IdentityLinkUtil.handleTaskIdentityLinkAdditions((TaskEntity)task, identityLinks);
    }

    public void addCandidateGroup(Task task, IdentityLink identityLink) {
        IdentityLinkUtil.handleTaskIdentityLinkAddition((TaskEntity)task, (IdentityLinkEntity)identityLink);
    }

    public void addCandidateGroups(Task task, List<IdentityLink> candidateGroups) {
        ArrayList<IdentityLinkEntity> identityLinks = new ArrayList<IdentityLinkEntity>();
        for (IdentityLink identityLink : candidateGroups) {
            identityLinks.add((IdentityLinkEntity)identityLink);
        }
        IdentityLinkUtil.handleTaskIdentityLinkAdditions((TaskEntity)task, identityLinks);
    }

    public void addUserIdentityLink(Task task, IdentityLink identityLink) {
        IdentityLinkUtil.handleTaskIdentityLinkAddition((TaskEntity)task, (IdentityLinkEntity)identityLink);
    }

    public void addGroupIdentityLink(Task task, IdentityLink identityLink) {
        IdentityLinkUtil.handleTaskIdentityLinkAddition((TaskEntity)task, (IdentityLinkEntity)identityLink);
    }

    public void deleteUserIdentityLink(Task task, IdentityLink identityLink) {
        ArrayList<IdentityLinkEntity> identityLinks = new ArrayList<IdentityLinkEntity>();
        identityLinks.add((IdentityLinkEntity)identityLink);
        IdentityLinkUtil.handleTaskIdentityLinkDeletions((TaskEntity)task, identityLinks, true);
    }

    public void deleteGroupIdentityLink(Task task, IdentityLink identityLink) {
        ArrayList<IdentityLinkEntity> identityLinks = new ArrayList<IdentityLinkEntity>();
        identityLinks.add((IdentityLinkEntity)identityLink);
        IdentityLinkUtil.handleTaskIdentityLinkDeletions((TaskEntity)task, identityLinks, true);
    }

    public void addUserIdentityLinkToParent(Task task, String userId) {
        CaseInstanceEntity caseInstanceEntity;
        if (userId != null && "cmmn".equals(task.getScopeType()) && StringUtils.isNotEmpty((CharSequence)task.getScopeId()) && (caseInstanceEntity = (CaseInstanceEntity)CommandContextUtil.getCaseInstanceEntityManager().findById(task.getScopeId())) != null) {
            List identityLinks = CommandContextUtil.getIdentityLinkService().findIdentityLinksByScopeIdAndType(caseInstanceEntity.getId(), "cmmn");
            for (IdentityLinkEntity identityLink : identityLinks) {
                if (!identityLink.isUser() || !identityLink.getUserId().equals(userId) || !this.parentIdentityLinkType.equals(identityLink.getType())) continue;
                return;
            }
            IdentityLinkUtil.createCaseInstanceIdentityLink(caseInstanceEntity, userId, null, this.parentIdentityLinkType);
        }
    }
}

