/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.behavior.impl;

import java.util.HashMap;
import java.util.List;
import liquibase.util.StringUtils;
import org.flowable.cmmn.api.delegate.DelegatePlanItemInstance;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.behavior.PlanItemActivityBehavior;
import org.flowable.cmmn.engine.impl.behavior.impl.TaskActivityBehavior;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.process.ProcessInstanceService;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.cmmn.engine.impl.util.EntityLinkUtil;
import org.flowable.cmmn.model.IOParameter;
import org.flowable.cmmn.model.Process;
import org.flowable.cmmn.model.ProcessTask;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.interceptor.CommandContext;

public class ProcessTaskActivityBehavior
extends TaskActivityBehavior
implements PlanItemActivityBehavior {
    protected Process process;
    protected Expression processRefExpression;
    protected String processRef;
    protected List<IOParameter> inParameters;
    protected List<IOParameter> outParameters;
    protected Boolean fallbackToDefaultTenant;

    public ProcessTaskActivityBehavior(Process process, Expression processRefExpression, ProcessTask processTask) {
        super(processTask.isBlocking(), processTask.getBlockingExpression());
        this.process = process;
        this.processRefExpression = processRefExpression;
        this.processRef = processTask.getProcessRef();
        this.inParameters = processTask.getInParameters();
        this.outParameters = processTask.getOutParameters();
        this.fallbackToDefaultTenant = processTask.getFallbackToDefaultTenant();
    }

    @Override
    public void execute(CommandContext commandContext, PlanItemInstanceEntity planItemInstanceEntity) {
        boolean blocking;
        CmmnEngineConfiguration cmmnEngineConfiguration = CommandContextUtil.getCmmnEngineConfiguration(commandContext);
        ProcessInstanceService processInstanceService = cmmnEngineConfiguration.getProcessInstanceService();
        if (processInstanceService == null) {
            throw new FlowableException("Could not start process instance: no " + ProcessInstanceService.class + " implementation found");
        }
        String externalRef = null;
        if (this.process != null) {
            externalRef = this.process.getExternalRef();
        } else if (this.processRefExpression != null) {
            externalRef = this.processRefExpression.getValue((VariableContainer)planItemInstanceEntity).toString();
        } else if (this.processRef != null) {
            externalRef = this.processRef;
        }
        if (StringUtils.isEmpty((String)externalRef)) {
            throw new FlowableException("Could not start process instance: no externalRef defined");
        }
        HashMap<String, Object> inParametersMap = new HashMap<String, Object>();
        for (IOParameter ioParameter : this.inParameters) {
            String variableName = null;
            if (StringUtils.isNotEmpty((String)ioParameter.getTargetExpression())) {
                Expression expression = cmmnEngineConfiguration.getExpressionManager().createExpression(ioParameter.getTargetExpression());
                variableName = expression.getValue((VariableContainer)planItemInstanceEntity).toString();
            } else if (StringUtils.isNotEmpty((String)ioParameter.getTarget())) {
                variableName = ioParameter.getTarget();
            }
            Object variableValue = null;
            if (StringUtils.isNotEmpty((String)ioParameter.getSourceExpression())) {
                Expression expression = cmmnEngineConfiguration.getExpressionManager().createExpression(ioParameter.getSourceExpression());
                variableValue = expression.getValue((VariableContainer)planItemInstanceEntity);
            } else if (StringUtils.isNotEmpty((String)ioParameter.getSource())) {
                variableValue = planItemInstanceEntity.getVariable(ioParameter.getSource());
            }
            inParametersMap.put(variableName, variableValue);
        }
        String processInstanceId = processInstanceService.generateNewProcessInstanceId();
        planItemInstanceEntity.setReferenceType("cmmn-1.1-to-bpmn-2.0-child-process");
        planItemInstanceEntity.setReferenceId(processInstanceId);
        if (CommandContextUtil.getCmmnEngineConfiguration(commandContext).isEnableEntityLinks()) {
            EntityLinkUtil.copyExistingEntityLinks(planItemInstanceEntity.getCaseInstanceId(), processInstanceId, "bpmn");
            EntityLinkUtil.createNewEntityLink(planItemInstanceEntity.getCaseInstanceId(), processInstanceId, "bpmn");
        }
        if (blocking = this.evaluateIsBlocking(planItemInstanceEntity)) {
            processInstanceService.startProcessInstanceByKey(externalRef, processInstanceId, planItemInstanceEntity.getId(), planItemInstanceEntity.getTenantId(), this.fallbackToDefaultTenant, inParametersMap);
        } else {
            processInstanceService.startProcessInstanceByKey(externalRef, processInstanceId, planItemInstanceEntity.getTenantId(), this.fallbackToDefaultTenant, inParametersMap);
        }
        if (!blocking) {
            CommandContextUtil.getAgenda(commandContext).planCompletePlanItemInstanceOperation(planItemInstanceEntity);
        }
    }

    @Override
    public void trigger(CommandContext commandContext, PlanItemInstanceEntity planItemInstance) {
        if (!"active".equals(planItemInstance.getState())) {
            throw new FlowableException("Can only trigger a plan item that is in the ACTIVE state");
        }
        if (planItemInstance.getReferenceId() == null) {
            throw new FlowableException("Cannot trigger process task plan item instance : no reference id set");
        }
        if (!"cmmn-1.1-to-bpmn-2.0-child-process".equals(planItemInstance.getReferenceType())) {
            throw new FlowableException("Cannot trigger process task plan item instance : reference type '" + planItemInstance.getReferenceType() + "' not supported");
        }
        CommandContextUtil.getAgenda(commandContext).planCompletePlanItemInstanceOperation(planItemInstance);
        this.deleteProcessInstance(commandContext, planItemInstance);
    }

    @Override
    public void onStateTransition(CommandContext commandContext, DelegatePlanItemInstance planItemInstance, String transition) {
        if ("active".equals(planItemInstance.getState())) {
            if ("terminate".equals(transition) || "exit".equals(transition)) {
                this.deleteProcessInstance(commandContext, planItemInstance);
            } else if ("complete".equals(transition)) {
                CmmnEngineConfiguration cmmnEngineConfiguration = CommandContextUtil.getCmmnEngineConfiguration(commandContext);
                ProcessInstanceService processInstanceService = cmmnEngineConfiguration.getProcessInstanceService();
                CaseInstanceEntity caseInstance = (CaseInstanceEntity)cmmnEngineConfiguration.getCaseInstanceEntityManager().findById(planItemInstance.getCaseInstanceId());
                for (IOParameter ioParameter : this.outParameters) {
                    String variableName = null;
                    if (StringUtils.isNotEmpty((String)ioParameter.getTarget())) {
                        variableName = ioParameter.getTarget();
                    } else if (StringUtils.isNotEmpty((String)ioParameter.getTargetExpression())) {
                        Expression expression = cmmnEngineConfiguration.getExpressionManager().createExpression(ioParameter.getTargetExpression());
                        variableName = expression.getValue((VariableContainer)planItemInstance).toString();
                    }
                    Object variableValue = null;
                    if (StringUtils.isNotEmpty((String)ioParameter.getSourceExpression())) {
                        Expression expression = cmmnEngineConfiguration.getExpressionManager().createExpression(ioParameter.getSourceExpression());
                        variableValue = processInstanceService.getVariables(planItemInstance.getReferenceId()).get(expression.getValue((VariableContainer)planItemInstance).toString());
                    } else if (StringUtils.isNotEmpty((String)ioParameter.getSource())) {
                        variableValue = processInstanceService.getVariables(planItemInstance.getReferenceId()).get(ioParameter.getSource());
                    }
                    caseInstance.setVariable(variableName, variableValue);
                }
            }
        }
    }

    protected void deleteProcessInstance(CommandContext commandContext, DelegatePlanItemInstance planItemInstance) {
        ProcessInstanceService processInstanceService = CommandContextUtil.getCmmnEngineConfiguration(commandContext).getProcessInstanceService();
        processInstanceService.deleteProcessInstance(planItemInstance.getReferenceId());
    }
}

