/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.converter.export;

import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.converter.CmmnXmlConstants;
import org.flowable.cmmn.converter.export.CriteriaExport;
import org.flowable.cmmn.model.PlanItem;
import org.flowable.cmmn.model.RepetitionRule;

public class PlanItemExport
implements CmmnXmlConstants {
    public static void writePlanItem(PlanItem planItem, XMLStreamWriter xtw) throws Exception {
        xtw.writeStartElement("planItem");
        xtw.writeAttribute("id", planItem.getId());
        if (StringUtils.isNotEmpty((CharSequence)planItem.getName())) {
            xtw.writeAttribute("name", planItem.getName());
        }
        if (StringUtils.isNotEmpty((CharSequence)planItem.getDefinitionRef())) {
            xtw.writeAttribute("definitionRef", planItem.getDefinitionRef());
        }
        if (StringUtils.isNotEmpty((CharSequence)planItem.getDocumentation())) {
            xtw.writeStartElement("documentation");
            xtw.writeCharacters(planItem.getDocumentation());
            xtw.writeEndElement();
        }
        if (planItem.getItemControl() != null) {
            xtw.writeStartElement("itemControl");
            RepetitionRule repetitionRule = planItem.getItemControl().getRepetitionRule();
            if (repetitionRule != null) {
                xtw.writeStartElement("repetitionRule");
                if (StringUtils.isNotEmpty((CharSequence)repetitionRule.getRepetitionCounterVariableName())) {
                    xtw.writeAttribute("flowable", "http://flowable.org/cmmn", "counterVariable", repetitionRule.getRepetitionCounterVariableName());
                }
                if (StringUtils.isNotEmpty((CharSequence)repetitionRule.getCondition())) {
                    xtw.writeStartElement("condition");
                    xtw.writeCData(repetitionRule.getCondition());
                    xtw.writeEndElement();
                }
                xtw.writeEndElement();
            }
            xtw.writeEndElement();
        }
        CriteriaExport.writeCriteriaElements(planItem, xtw);
        xtw.writeEndElement();
    }
}

