/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.converter;

import javax.xml.stream.XMLStreamReader;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.converter.ConversionHelper;
import org.flowable.cmmn.converter.PlanItemDefinitiomXmlConverter;
import org.flowable.cmmn.model.CmmnElement;
import org.flowable.cmmn.model.HttpServiceTask;
import org.flowable.cmmn.model.ImplementationType;
import org.flowable.cmmn.model.ServiceTask;
import org.flowable.cmmn.model.Task;

public class TaskXmlConverter
extends PlanItemDefinitiomXmlConverter {
    @Override
    public String getXMLElementName() {
        return "task";
    }

    @Override
    public boolean hasChildElements() {
        return true;
    }

    protected CmmnElement convert(XMLStreamReader xtr, ConversionHelper conversionHelper) {
        Task task = null;
        String type = xtr.getAttributeValue("http://flowable.org/cmmn", "type");
        String className = xtr.getAttributeValue("http://flowable.org/cmmn", "class");
        if ("java".equals(type)) {
            ServiceTask serviceTask = new ServiceTask();
            serviceTask.setType("java");
            if (StringUtils.isNotEmpty((CharSequence)className)) {
                serviceTask.setImplementation(className);
            }
            String expression = xtr.getAttributeValue("http://flowable.org/cmmn", "expression");
            String delegateExpression = xtr.getAttributeValue("http://flowable.org/cmmn", "delegateExpression");
            if (StringUtils.isNotEmpty((CharSequence)className)) {
                serviceTask.setImplementationType(ImplementationType.IMPLEMENTATION_TYPE_CLASS);
            } else if (StringUtils.isNotEmpty((CharSequence)expression)) {
                serviceTask.setImplementation(expression);
                serviceTask.setImplementationType(ImplementationType.IMPLEMENTATION_TYPE_EXPRESSION);
            } else if (StringUtils.isNotEmpty((CharSequence)delegateExpression)) {
                serviceTask.setImplementation(delegateExpression);
                serviceTask.setImplementationType(ImplementationType.IMPLEMENTATION_TYPE_DELEGATEEXPRESSION);
            }
            serviceTask.setResultVariableName(xtr.getAttributeValue("http://flowable.org/cmmn", "resultVariableName"));
            task = serviceTask;
        } else if ("http".equals(type)) {
            HttpServiceTask httpServiceTask = new HttpServiceTask();
            if (StringUtils.isNotEmpty((CharSequence)className)) {
                httpServiceTask.setImplementation(className);
            }
            task = httpServiceTask;
        } else {
            task = new Task();
        }
        this.convertCommonTaskAttributes(xtr, task);
        return task;
    }

    protected void convertCommonTaskAttributes(XMLStreamReader xtr, Task task) {
        String isBlockingExpressionString;
        task.setName(xtr.getAttributeValue(null, "name"));
        String isBlockingString = xtr.getAttributeValue(null, "isBlocking");
        if (StringUtils.isNotEmpty((CharSequence)isBlockingString)) {
            task.setBlocking(Boolean.valueOf(isBlockingString).booleanValue());
        }
        if (StringUtils.isNotEmpty((CharSequence)(isBlockingExpressionString = xtr.getAttributeValue("http://flowable.org/cmmn", "isBlockingExpression")))) {
            task.setBlockingExpression(isBlockingExpressionString);
        }
    }
}

