/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.bpmn.converter;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.converter.BaseBpmnXMLConverter;
import org.flowable.bpmn.converter.child.BaseChildElementParser;
import org.flowable.bpmn.converter.child.EventInParameterParser;
import org.flowable.bpmn.converter.child.EventOutParameterParser;
import org.flowable.bpmn.converter.child.ExternalWorkerInParameterParser;
import org.flowable.bpmn.converter.child.ExternalWorkerOutParameterParser;
import org.flowable.bpmn.converter.child.InParameterParser;
import org.flowable.bpmn.converter.child.OutParameterParser;
import org.flowable.bpmn.converter.export.FieldExtensionExport;
import org.flowable.bpmn.converter.export.MapExceptionExport;
import org.flowable.bpmn.converter.export.ScriptInfoExport;
import org.flowable.bpmn.converter.util.BpmnXMLUtil;
import org.flowable.bpmn.model.AbstractFlowableHttpHandler;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.CaseServiceTask;
import org.flowable.bpmn.model.CustomProperty;
import org.flowable.bpmn.model.ExtensionAttribute;
import org.flowable.bpmn.model.ExtensionElement;
import org.flowable.bpmn.model.ExternalWorkerServiceTask;
import org.flowable.bpmn.model.HttpServiceTask;
import org.flowable.bpmn.model.SendEventServiceTask;
import org.flowable.bpmn.model.ServiceTask;

public class ServiceTaskXMLConverter
extends BaseBpmnXMLConverter {
    protected Map<String, BaseChildElementParser> caseServiceChildParserMap = new HashMap<String, BaseChildElementParser>();
    protected Map<String, BaseChildElementParser> sendEventServiceChildParserMap = new HashMap<String, BaseChildElementParser>();
    protected Map<String, BaseChildElementParser> externalWorkerTaskChildParserMap = new HashMap<String, BaseChildElementParser>();
    protected static final List<ExtensionAttribute> defaultServiceTaskAttributes = Arrays.asList(new ExtensionAttribute("type"), new ExtensionAttribute("class"), new ExtensionAttribute("expression"), new ExtensionAttribute("delegateExpression"), new ExtensionAttribute("implementation"), new ExtensionAttribute("operationRef"), new ExtensionAttribute("resultVariableName"), new ExtensionAttribute("resultVariable"), new ExtensionAttribute("useLocalScopeForResultVariable"), new ExtensionAttribute("storeResultVariableAsTransient"), new ExtensionAttribute("extensionId"), new ExtensionAttribute("skipExpression"), new ExtensionAttribute("triggerable"), new ExtensionAttribute("topic"), new ExtensionAttribute("parallelInSameTransaction"), new ExtensionAttribute("caseDefinitionKey"), new ExtensionAttribute("caseInstanceName"), new ExtensionAttribute("businessKey"), new ExtensionAttribute("inheritBusinessKey"), new ExtensionAttribute("sameDeployment"), new ExtensionAttribute("fallbackToDefaultTenant"), new ExtensionAttribute("idVariableName"));

    public ServiceTaskXMLConverter() {
        InParameterParser inParameterParser = new InParameterParser();
        this.caseServiceChildParserMap.put(inParameterParser.getElementName(), inParameterParser);
        OutParameterParser outParameterParser = new OutParameterParser();
        this.caseServiceChildParserMap.put(outParameterParser.getElementName(), outParameterParser);
        EventInParameterParser eventInParameterParser = new EventInParameterParser();
        this.sendEventServiceChildParserMap.put(eventInParameterParser.getElementName(), eventInParameterParser);
        EventOutParameterParser eventOutParameterParser = new EventOutParameterParser();
        this.sendEventServiceChildParserMap.put(eventOutParameterParser.getElementName(), eventOutParameterParser);
        ExternalWorkerInParameterParser externalWorkerInParameterParser = new ExternalWorkerInParameterParser();
        this.externalWorkerTaskChildParserMap.put(externalWorkerInParameterParser.getElementName(), externalWorkerInParameterParser);
        ExternalWorkerOutParameterParser externalWorkerOutParameterParser = new ExternalWorkerOutParameterParser();
        this.externalWorkerTaskChildParserMap.put(externalWorkerOutParameterParser.getElementName(), externalWorkerOutParameterParser);
    }

    @Override
    public Class<? extends BaseElement> getBpmnElementType() {
        return ServiceTask.class;
    }

    @Override
    protected String getXMLElementName() {
        return "serviceTask";
    }

    @Override
    protected BaseElement convertXMLToElement(XMLStreamReader xtr, BpmnModel model) throws Exception {
        String serviceTaskType = BpmnXMLUtil.getAttributeValue("type", xtr);
        HttpServiceTask serviceTask = null;
        if ("http".equals(serviceTaskType)) {
            serviceTask = new HttpServiceTask();
        } else if ("case".equals(serviceTaskType)) {
            serviceTask = new CaseServiceTask();
        } else if ("send-event".equals(serviceTaskType)) {
            serviceTask = new SendEventServiceTask();
        } else if ("external-worker".equals(serviceTaskType) || "external".equals(serviceTaskType)) {
            serviceTaskType = "external-worker";
            serviceTask = new ExternalWorkerServiceTask();
        } else {
            serviceTask = new ServiceTask();
        }
        BpmnXMLUtil.addXMLLocation((BaseElement)serviceTask, xtr);
        if (StringUtils.isNotEmpty((CharSequence)BpmnXMLUtil.getAttributeValue("class", xtr))) {
            serviceTask.setImplementationType("class");
            serviceTask.setImplementation(BpmnXMLUtil.getAttributeValue("class", xtr));
        } else if (StringUtils.isNotEmpty((CharSequence)BpmnXMLUtil.getAttributeValue("expression", xtr))) {
            serviceTask.setImplementationType("expression");
            serviceTask.setImplementation(BpmnXMLUtil.getAttributeValue("expression", xtr));
        } else if (StringUtils.isNotEmpty((CharSequence)BpmnXMLUtil.getAttributeValue("delegateExpression", xtr))) {
            serviceTask.setImplementationType("delegateExpression");
            serviceTask.setImplementation(BpmnXMLUtil.getAttributeValue("delegateExpression", xtr));
        } else if ("##WebService".equals(xtr.getAttributeValue(null, "implementation"))) {
            serviceTask.setImplementationType("##WebService");
            serviceTask.setOperationRef(this.parseOperationRef(xtr.getAttributeValue(null, "operationRef"), model));
        }
        serviceTask.setResultVariableName(BpmnXMLUtil.getAttributeValue("resultVariableName", xtr));
        if (StringUtils.isEmpty((CharSequence)serviceTask.getResultVariableName())) {
            serviceTask.setResultVariableName(BpmnXMLUtil.getAttributeValue("resultVariable", xtr));
        }
        serviceTask.setUseLocalScopeForResultVariable(Boolean.parseBoolean(BpmnXMLUtil.getAttributeValue("useLocalScopeForResultVariable", xtr)));
        serviceTask.setStoreResultVariableAsTransient(Boolean.parseBoolean(BpmnXMLUtil.getAttributeValue("storeResultVariableAsTransient", xtr)));
        serviceTask.setType(serviceTaskType);
        serviceTask.setExtensionId(BpmnXMLUtil.getAttributeValue("extensionId", xtr));
        if (StringUtils.isNotEmpty((CharSequence)BpmnXMLUtil.getAttributeValue("skipExpression", xtr))) {
            serviceTask.setSkipExpression(BpmnXMLUtil.getAttributeValue("skipExpression", xtr));
        }
        BpmnXMLUtil.addCustomAttributes(xtr, (BaseElement)serviceTask, defaultElementAttributes, defaultActivityAttributes, defaultServiceTaskAttributes);
        if (serviceTask instanceof CaseServiceTask) {
            this.convertCaseServiceTaskXMLProperties((CaseServiceTask)serviceTask, model, xtr);
        } else if (serviceTask instanceof SendEventServiceTask) {
            this.convertSendEventServiceTaskXMLProperties((SendEventServiceTask)serviceTask, model, xtr);
        } else if (serviceTask instanceof ExternalWorkerServiceTask) {
            this.convertExternalWorkerTaskXMLProperties((ExternalWorkerServiceTask)serviceTask, model, xtr);
        } else if (serviceTask instanceof HttpServiceTask) {
            this.convertHttpServiceTaskXMLProperties(serviceTask, model, xtr);
        } else {
            this.parseChildElements(this.getXMLElementName(), (BaseElement)serviceTask, model, xtr);
        }
        return serviceTask;
    }

    @Override
    protected void writeAdditionalAttributes(BaseElement element, BpmnModel model, XMLStreamWriter xtw) throws Exception {
        if (element instanceof CaseServiceTask) {
            this.writeCaseServiceTaskAdditionalAttributes(element, model, xtw);
        } else if (element instanceof SendEventServiceTask) {
            this.writeSendEventServiceAdditionalAttributes(element, model, xtw);
        } else if (element instanceof ExternalWorkerServiceTask) {
            this.writeExternalTaskAdditionalAttributes((ExternalWorkerServiceTask)element, model, xtw);
        } else if (element instanceof HttpServiceTask) {
            this.writeHttpServiceTaskAdditionalAttributes((HttpServiceTask)element, model, xtw);
        } else {
            this.writeServiceTaskAdditionalAttributes((ServiceTask)element, xtw);
        }
    }

    protected void writeCaseServiceTaskAdditionalAttributes(BaseElement element, BpmnModel model, XMLStreamWriter xtw) throws Exception {
        CaseServiceTask caseServiceTask = (CaseServiceTask)element;
        this.writeQualifiedAttribute("type", "case", xtw);
        if (StringUtils.isNotEmpty((CharSequence)caseServiceTask.getSkipExpression())) {
            this.writeQualifiedAttribute("skipExpression", caseServiceTask.getSkipExpression(), xtw);
        }
        if (StringUtils.isNotEmpty((CharSequence)caseServiceTask.getCaseDefinitionKey())) {
            this.writeQualifiedAttribute("caseDefinitionKey", caseServiceTask.getCaseDefinitionKey(), xtw);
        }
        if (StringUtils.isNotEmpty((CharSequence)caseServiceTask.getCaseInstanceName())) {
            this.writeQualifiedAttribute("caseInstanceName", caseServiceTask.getCaseInstanceName(), xtw);
        }
        if (StringUtils.isNotEmpty((CharSequence)caseServiceTask.getBusinessKey())) {
            this.writeQualifiedAttribute("businessKey", caseServiceTask.getBusinessKey(), xtw);
        }
        if (caseServiceTask.isInheritBusinessKey()) {
            this.writeQualifiedAttribute("inheritBusinessKey", "true", xtw);
        }
        if (caseServiceTask.isSameDeployment()) {
            this.writeQualifiedAttribute("sameDeployment", "true", xtw);
        }
        if (caseServiceTask.isFallbackToDefaultTenant()) {
            this.writeQualifiedAttribute("fallbackToDefaultTenant", "true", xtw);
        }
        if (StringUtils.isNotEmpty((CharSequence)caseServiceTask.getCaseInstanceIdVariableName())) {
            this.writeQualifiedAttribute("idVariableName", caseServiceTask.getCaseInstanceIdVariableName(), xtw);
        }
    }

    protected void writeSendEventServiceAdditionalAttributes(BaseElement element, BpmnModel model, XMLStreamWriter xtw) throws Exception {
        SendEventServiceTask sendEventServiceTask = (SendEventServiceTask)element;
        this.writeQualifiedAttribute("type", "send-event", xtw);
        if (StringUtils.isNotEmpty((CharSequence)sendEventServiceTask.getSkipExpression())) {
            this.writeQualifiedAttribute("skipExpression", sendEventServiceTask.getSkipExpression(), xtw);
        }
        if (sendEventServiceTask.isTriggerable()) {
            this.writeQualifiedAttribute("triggerable", "true", xtw);
        }
    }

    protected void writeExternalTaskAdditionalAttributes(ExternalWorkerServiceTask externalWorkerTask, BpmnModel model, XMLStreamWriter xtw) throws Exception {
        this.writeQualifiedAttribute("type", "external-worker", xtw);
        this.writeQualifiedAttribute("topic", externalWorkerTask.getTopic(), xtw);
        if (!externalWorkerTask.isAsynchronous() && externalWorkerTask.isNotExclusive()) {
            this.writeQualifiedAttribute("exclusive", "false", xtw);
        }
        if (StringUtils.isNotEmpty((CharSequence)externalWorkerTask.getSkipExpression())) {
            this.writeQualifiedAttribute("skipExpression", externalWorkerTask.getSkipExpression(), xtw);
        }
        if (externalWorkerTask.isDoNotIncludeVariables()) {
            this.writeQualifiedAttribute("doNotIncludeVariables", String.valueOf(externalWorkerTask.isDoNotIncludeVariables()), xtw);
        }
    }

    protected void writeHttpServiceTaskAdditionalAttributes(HttpServiceTask httpServiceTask, BpmnModel model, XMLStreamWriter xtw) throws Exception {
        if (httpServiceTask.getParallelInSameTransaction() != null) {
            this.writeQualifiedAttribute("parallelInSameTransaction", httpServiceTask.getParallelInSameTransaction().toString(), xtw);
        }
        this.writeServiceTaskAdditionalAttributes((ServiceTask)httpServiceTask, xtw);
    }

    protected void writeServiceTaskAdditionalAttributes(ServiceTask element, XMLStreamWriter xtw) throws Exception {
        ServiceTask serviceTask = element;
        if ("class".equals(serviceTask.getImplementationType())) {
            this.writeQualifiedAttribute("class", serviceTask.getImplementation(), xtw);
        } else if ("expression".equals(serviceTask.getImplementationType())) {
            this.writeQualifiedAttribute("expression", serviceTask.getImplementation(), xtw);
        } else if ("delegateExpression".equals(serviceTask.getImplementationType())) {
            this.writeQualifiedAttribute("delegateExpression", serviceTask.getImplementation(), xtw);
        }
        if (StringUtils.isNotEmpty((CharSequence)serviceTask.getResultVariableName())) {
            this.writeQualifiedAttribute("resultVariableName", serviceTask.getResultVariableName(), xtw);
        }
        if (StringUtils.isNotEmpty((CharSequence)serviceTask.getType())) {
            this.writeQualifiedAttribute("type", serviceTask.getType(), xtw);
        }
        if (StringUtils.isNotEmpty((CharSequence)serviceTask.getExtensionId())) {
            this.writeQualifiedAttribute("extensionId", serviceTask.getExtensionId(), xtw);
        }
        if (StringUtils.isNotEmpty((CharSequence)serviceTask.getSkipExpression())) {
            this.writeQualifiedAttribute("skipExpression", serviceTask.getSkipExpression(), xtw);
        }
        if (serviceTask.isTriggerable()) {
            this.writeQualifiedAttribute("triggerable", "true", xtw);
        }
        if (serviceTask.isUseLocalScopeForResultVariable()) {
            this.writeQualifiedAttribute("useLocalScopeForResultVariable", "true", xtw);
        }
        if (serviceTask.isStoreResultVariableAsTransient()) {
            this.writeQualifiedAttribute("storeResultVariableAsTransient", "true", xtw);
        }
    }

    @Override
    protected boolean writeExtensionChildElements(BaseElement element, boolean didWriteExtensionStartElement, XMLStreamWriter xtw) throws Exception {
        if (element instanceof CaseServiceTask) {
            return this.writeCaseServiceTaskExtensionChildElements(element, didWriteExtensionStartElement, xtw);
        }
        if (element instanceof SendEventServiceTask) {
            return this.writeSendServiceExtensionChildElements(element, didWriteExtensionStartElement, xtw);
        }
        if (element instanceof ExternalWorkerServiceTask) {
            return this.writeExternalWorkerTaskExtensionChildElements(element, didWriteExtensionStartElement, xtw);
        }
        return this.writeServiceTaskExtensionChildElements((ServiceTask)element, didWriteExtensionStartElement, xtw);
    }

    protected boolean writeServiceTaskExtensionChildElements(ServiceTask element, boolean didWriteExtensionStartElement, XMLStreamWriter xtw) throws Exception {
        ServiceTask serviceTask = element;
        if (!serviceTask.getCustomProperties().isEmpty()) {
            this.writeCustomProperties(serviceTask, didWriteExtensionStartElement, xtw);
        } else {
            if (serviceTask instanceof HttpServiceTask) {
                didWriteExtensionStartElement = this.writeHttpTaskExtensionElements((HttpServiceTask)serviceTask, didWriteExtensionStartElement, xtw);
            }
            didWriteExtensionStartElement = FieldExtensionExport.writeFieldExtensions(serviceTask.getFieldExtensions(), didWriteExtensionStartElement, xtw);
            didWriteExtensionStartElement = MapExceptionExport.writeMapExceptionExtensions(serviceTask.getMapExceptions(), didWriteExtensionStartElement, xtw);
        }
        return didWriteExtensionStartElement;
    }

    protected boolean writeSendServiceExtensionChildElements(BaseElement element, boolean didWriteExtensionStartElement, XMLStreamWriter xtw) throws Exception {
        SendEventServiceTask sendEventServiceTask = (SendEventServiceTask)element;
        if (!didWriteExtensionStartElement) {
            xtw.writeStartElement("extensionElements");
            didWriteExtensionStartElement = true;
        }
        xtw.writeStartElement("flowable", "eventType", "http://flowable.org/bpmn");
        if (StringUtils.isNotEmpty((CharSequence)sendEventServiceTask.getEventType())) {
            xtw.writeCData(sendEventServiceTask.getEventType());
        } else {
            LOGGER.warn("No event type configured for send event task {}", (Object)sendEventServiceTask.getId());
        }
        xtw.writeEndElement();
        if (StringUtils.isNotEmpty((CharSequence)sendEventServiceTask.getTriggerEventType())) {
            xtw.writeStartElement("flowable", "triggerEventType", "http://flowable.org/bpmn");
            xtw.writeCData(sendEventServiceTask.getTriggerEventType());
            xtw.writeEndElement();
        }
        if (sendEventServiceTask.isSendSynchronously()) {
            xtw.writeStartElement("flowable", "sendSynchronously", "http://flowable.org/bpmn");
            xtw.writeCData(String.valueOf(sendEventServiceTask.isSendSynchronously()));
            xtw.writeEndElement();
        }
        BpmnXMLUtil.writeIOParameters("eventInParameter", sendEventServiceTask.getEventInParameters(), didWriteExtensionStartElement, xtw);
        BpmnXMLUtil.writeIOParameters("eventOutParameter", sendEventServiceTask.getEventOutParameters(), didWriteExtensionStartElement, xtw);
        return didWriteExtensionStartElement;
    }

    protected boolean writeExternalWorkerTaskExtensionChildElements(BaseElement element, boolean didWriteExtensionStartElement, XMLStreamWriter xtw) throws Exception {
        ExternalWorkerServiceTask externalWorkerTask = (ExternalWorkerServiceTask)element;
        didWriteExtensionStartElement = BpmnXMLUtil.writeIOParameters("externalWorkerInParameter", externalWorkerTask.getInParameters(), didWriteExtensionStartElement, xtw);
        didWriteExtensionStartElement = BpmnXMLUtil.writeIOParameters("externalWorkerOutParameter", externalWorkerTask.getOutParameters(), didWriteExtensionStartElement, xtw);
        return didWriteExtensionStartElement;
    }

    protected boolean writeCaseServiceTaskExtensionChildElements(BaseElement element, boolean didWriteExtensionStartElement, XMLStreamWriter xtw) throws Exception {
        CaseServiceTask caseServiceTask = (CaseServiceTask)element;
        didWriteExtensionStartElement = BpmnXMLUtil.writeIOParameters("in", caseServiceTask.getInParameters(), didWriteExtensionStartElement, xtw);
        didWriteExtensionStartElement = BpmnXMLUtil.writeIOParameters("out", caseServiceTask.getOutParameters(), didWriteExtensionStartElement, xtw);
        return didWriteExtensionStartElement;
    }

    @Override
    protected void writeAdditionalChildElements(BaseElement element, BpmnModel model, XMLStreamWriter xtw) throws Exception {
    }

    protected void convertCaseServiceTaskXMLProperties(CaseServiceTask caseServiceTask, BpmnModel bpmnModel, XMLStreamReader xtr) throws Exception {
        String caseInstanceName;
        String caseDefinitionKey = BpmnXMLUtil.getAttributeValue("caseDefinitionKey", xtr);
        if (StringUtils.isNotEmpty((CharSequence)caseDefinitionKey)) {
            caseServiceTask.setCaseDefinitionKey(caseDefinitionKey);
        }
        if (StringUtils.isNotEmpty((CharSequence)(caseInstanceName = BpmnXMLUtil.getAttributeValue("caseInstanceName", xtr)))) {
            caseServiceTask.setCaseInstanceName(caseInstanceName);
        }
        caseServiceTask.setBusinessKey(BpmnXMLUtil.getAttributeValue("businessKey", xtr));
        caseServiceTask.setInheritBusinessKey(Boolean.parseBoolean(BpmnXMLUtil.getAttributeValue("inheritBusinessKey", xtr)));
        caseServiceTask.setSameDeployment(Boolean.valueOf(BpmnXMLUtil.getAttributeValue("sameDeployment", xtr)).booleanValue());
        caseServiceTask.setFallbackToDefaultTenant(Boolean.valueOf(BpmnXMLUtil.getAttributeValue("fallbackToDefaultTenant", xtr)).booleanValue());
        caseServiceTask.setCaseInstanceIdVariableName(BpmnXMLUtil.getAttributeValue("idVariableName", xtr));
        this.parseChildElements(this.getXMLElementName(), (BaseElement)caseServiceTask, this.caseServiceChildParserMap, bpmnModel, xtr);
    }

    protected void convertSendEventServiceTaskXMLProperties(SendEventServiceTask sendEventServiceTask, BpmnModel bpmnModel, XMLStreamReader xtr) throws Exception {
        String triggerable = BpmnXMLUtil.getAttributeValue("triggerable", xtr);
        if ("true".equalsIgnoreCase(triggerable)) {
            sendEventServiceTask.setTriggerable(true);
        }
        this.parseChildElements(this.getXMLElementName(), (BaseElement)sendEventServiceTask, this.sendEventServiceChildParserMap, bpmnModel, xtr);
        if (sendEventServiceTask.getExtensionElements() != null) {
            String sendSyncValue;
            List sendSyncExtensionElements;
            String triggerEventType;
            List triggerEventTypeExtensionElements;
            String eventTypeValue;
            List eventTypeExtensionElements = (List)sendEventServiceTask.getExtensionElements().get("eventType");
            if (eventTypeExtensionElements != null && !eventTypeExtensionElements.isEmpty() && StringUtils.isNotEmpty((CharSequence)(eventTypeValue = ((ExtensionElement)eventTypeExtensionElements.get(0)).getElementText()))) {
                sendEventServiceTask.setEventType(eventTypeValue);
            }
            if ((triggerEventTypeExtensionElements = (List)sendEventServiceTask.getExtensionElements().get("triggerEventType")) != null && !triggerEventTypeExtensionElements.isEmpty() && StringUtils.isNotEmpty((CharSequence)(triggerEventType = ((ExtensionElement)triggerEventTypeExtensionElements.get(0)).getElementText()))) {
                sendEventServiceTask.setTriggerEventType(triggerEventType);
            }
            if ((sendSyncExtensionElements = (List)sendEventServiceTask.getExtensionElements().get("sendSynchronously")) != null && !sendSyncExtensionElements.isEmpty() && StringUtils.isNotEmpty((CharSequence)(sendSyncValue = ((ExtensionElement)sendSyncExtensionElements.get(0)).getElementText())) && "true".equalsIgnoreCase(sendSyncValue)) {
                sendEventServiceTask.setSendSynchronously(true);
            }
        }
    }

    protected void convertExternalWorkerTaskXMLProperties(ExternalWorkerServiceTask externalWorkerServiceTask, BpmnModel bpmnModel, XMLStreamReader xtr) throws Exception {
        externalWorkerServiceTask.setTopic(BpmnXMLUtil.getAttributeValue("topic", xtr));
        externalWorkerServiceTask.setDoNotIncludeVariables(Boolean.parseBoolean(BpmnXMLUtil.getAttributeValue("doNotIncludeVariables", xtr)));
        this.parseChildElements(this.getXMLElementName(), (BaseElement)externalWorkerServiceTask, this.externalWorkerTaskChildParserMap, bpmnModel, xtr);
    }

    protected void convertHttpServiceTaskXMLProperties(HttpServiceTask httpServiceTask, BpmnModel bpmnModel, XMLStreamReader xtr) throws Exception {
        String parallelInSameTransaction = BpmnXMLUtil.getAttributeValue("parallelInSameTransaction", xtr);
        if (StringUtils.isNotEmpty((CharSequence)parallelInSameTransaction)) {
            httpServiceTask.setParallelInSameTransaction(Boolean.valueOf(Boolean.parseBoolean(parallelInSameTransaction)));
        }
        this.parseChildElements(this.getXMLElementName(), (BaseElement)httpServiceTask, bpmnModel, xtr);
    }

    protected boolean writeCustomProperties(ServiceTask serviceTask, boolean didWriteExtensionStartElement, XMLStreamWriter xtw) throws Exception {
        for (CustomProperty customProperty : serviceTask.getCustomProperties()) {
            if (StringUtils.isEmpty((CharSequence)customProperty.getSimpleValue())) continue;
            if (!didWriteExtensionStartElement) {
                xtw.writeStartElement("extensionElements");
                didWriteExtensionStartElement = true;
            }
            xtw.writeStartElement("flowable", "field", "http://flowable.org/bpmn");
            xtw.writeAttribute("name", customProperty.getName());
            if ((customProperty.getSimpleValue().contains("${") || customProperty.getSimpleValue().contains("#{")) && customProperty.getSimpleValue().contains("}")) {
                xtw.writeStartElement("flowable", "expression", "http://flowable.org/bpmn");
            } else {
                xtw.writeStartElement("flowable", "string", "http://flowable.org/bpmn");
            }
            xtw.writeCharacters(customProperty.getSimpleValue());
            xtw.writeEndElement();
            xtw.writeEndElement();
        }
        return didWriteExtensionStartElement;
    }

    protected boolean writeHttpTaskExtensionElements(HttpServiceTask httpServiceTask, boolean didWriteExtensionStartElement, XMLStreamWriter xtw) throws Exception {
        if (httpServiceTask.getHttpRequestHandler() != null) {
            if (!didWriteExtensionStartElement) {
                xtw.writeStartElement("extensionElements");
                didWriteExtensionStartElement = true;
            }
            xtw.writeStartElement("flowable", "httpRequestHandler", "http://flowable.org/bpmn");
            this.writeHttpHandlerAttributes((AbstractFlowableHttpHandler)httpServiceTask.getHttpRequestHandler(), xtw);
            xtw.writeEndElement();
        }
        if (httpServiceTask.getHttpResponseHandler() != null) {
            if (!didWriteExtensionStartElement) {
                xtw.writeStartElement("extensionElements");
                didWriteExtensionStartElement = true;
            }
            xtw.writeStartElement("flowable", "httpResponseHandler", "http://flowable.org/bpmn");
            this.writeHttpHandlerAttributes((AbstractFlowableHttpHandler)httpServiceTask.getHttpResponseHandler(), xtw);
            xtw.writeEndElement();
        }
        return didWriteExtensionStartElement;
    }

    protected String parseOperationRef(String operationRef, BpmnModel model) {
        String result = null;
        if (StringUtils.isNotEmpty((CharSequence)operationRef)) {
            int indexOfP = operationRef.indexOf(58);
            if (indexOfP != -1) {
                String prefix = operationRef.substring(0, indexOfP);
                String resolvedNamespace = model.getNamespace(prefix);
                result = resolvedNamespace + ":" + operationRef.substring(indexOfP + 1);
            } else {
                result = model.getTargetNamespace() + ":" + operationRef;
            }
        }
        return result;
    }

    protected void writeHttpHandlerAttributes(AbstractFlowableHttpHandler httpHandler, XMLStreamWriter xtw) throws Exception {
        if ("class".equals(httpHandler.getImplementationType())) {
            xtw.writeAttribute("class", httpHandler.getImplementation());
        } else if ("delegateExpression".equals(httpHandler.getImplementationType())) {
            xtw.writeAttribute("delegateExpression", httpHandler.getImplementation());
        } else if ("script".equals(httpHandler.getImplementationType())) {
            xtw.writeAttribute("type", httpHandler.getImplementationType());
        }
        if (httpHandler.getScriptInfo() != null) {
            ScriptInfoExport.writeScriptInfo(xtw, httpHandler.getScriptInfo());
        }
    }
}

