/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.bpmn.converter;

import java.text.SimpleDateFormat;
import java.util.List;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.converter.BaseBpmnXMLConverter;
import org.flowable.bpmn.converter.util.BpmnXMLUtil;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.BooleanDataObject;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.DateDataObject;
import org.flowable.bpmn.model.DoubleDataObject;
import org.flowable.bpmn.model.ExtensionElement;
import org.flowable.bpmn.model.IntegerDataObject;
import org.flowable.bpmn.model.ItemDefinition;
import org.flowable.bpmn.model.JsonDataObject;
import org.flowable.bpmn.model.LongDataObject;
import org.flowable.bpmn.model.StringDataObject;
import org.flowable.bpmn.model.ValuedDataObject;

public class ValuedDataObjectXMLConverter
extends BaseBpmnXMLConverter {
    private final Pattern xmlChars = Pattern.compile("[<>&]");
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    protected boolean didWriteExtensionStartElement;

    @Override
    public Class<? extends BaseElement> getBpmnElementType() {
        return ValuedDataObject.class;
    }

    @Override
    protected String getXMLElementName() {
        return "dataObject";
    }

    @Override
    protected BaseElement convertXMLToElement(XMLStreamReader xtr, BpmnModel model) throws Exception {
        StringDataObject dataObject = null;
        ItemDefinition itemSubjectRef = new ItemDefinition();
        String structureRef = xtr.getAttributeValue(null, "itemSubjectRef");
        if (StringUtils.isNotEmpty((CharSequence)structureRef) && structureRef.contains(":")) {
            String dataType = structureRef.substring(structureRef.indexOf(58) + 1);
            if ("string".equals(dataType)) {
                dataObject = new StringDataObject();
            } else if ("int".equals(dataType)) {
                dataObject = new IntegerDataObject();
            } else if ("long".equals(dataType)) {
                dataObject = new LongDataObject();
            } else if ("double".equals(dataType)) {
                dataObject = new DoubleDataObject();
            } else if ("boolean".equals(dataType)) {
                dataObject = new BooleanDataObject();
            } else if ("datetime".equals(dataType)) {
                dataObject = new DateDataObject();
            } else if ("json".equals(dataType)) {
                dataObject = new JsonDataObject();
            } else {
                LOGGER.error("Error converting {}, invalid data type: {}", (Object)xtr.getAttributeValue(null, "name"), (Object)dataType);
            }
        } else {
            dataObject = new StringDataObject();
            structureRef = "xsd:string";
        }
        if (dataObject != null) {
            dataObject.setId(xtr.getAttributeValue(null, "id"));
            dataObject.setName(xtr.getAttributeValue(null, "name"));
            BpmnXMLUtil.addXMLLocation((BaseElement)dataObject, xtr);
            itemSubjectRef.setStructureRef(structureRef);
            dataObject.setItemSubjectRef(itemSubjectRef);
            this.parseChildElements(this.getXMLElementName(), (BaseElement)dataObject, model, xtr);
            List valuesElement = (List)dataObject.getExtensionElements().get("value");
            if (valuesElement != null && !valuesElement.isEmpty()) {
                ExtensionElement valueElement = (ExtensionElement)valuesElement.get(0);
                if (StringUtils.isNotEmpty((CharSequence)valueElement.getElementText())) {
                    if (dataObject instanceof DateDataObject) {
                        try {
                            dataObject.setValue((Object)this.sdf.parse(valueElement.getElementText()));
                        }
                        catch (Exception e) {
                            LOGGER.error("Error converting {}; message={}", (Object)dataObject.getName(), (Object)e.getMessage());
                        }
                    } else {
                        dataObject.setValue((Object)valueElement.getElementText());
                    }
                }
                dataObject.getExtensionElements().remove("value");
            }
        }
        return dataObject;
    }

    @Override
    protected void writeAdditionalAttributes(BaseElement element, BpmnModel model, XMLStreamWriter xtw) throws Exception {
        ValuedDataObject dataObject = (ValuedDataObject)element;
        if (dataObject.getItemSubjectRef() != null && StringUtils.isNotEmpty((CharSequence)dataObject.getItemSubjectRef().getStructureRef())) {
            this.writeDefaultAttribute("itemSubjectRef", dataObject.getItemSubjectRef().getStructureRef(), xtw);
        }
    }

    @Override
    protected boolean writeExtensionChildElements(BaseElement element, boolean didWriteExtensionStartElement, XMLStreamWriter xtw) throws Exception {
        ValuedDataObject dataObject = (ValuedDataObject)element;
        if (StringUtils.isNotEmpty((CharSequence)dataObject.getId()) && dataObject.getValue() != null) {
            if (!didWriteExtensionStartElement) {
                xtw.writeStartElement("extensionElements");
                didWriteExtensionStartElement = true;
            }
            xtw.writeStartElement("flowable", "value", "http://flowable.org/bpmn");
            if (dataObject.getValue() != null) {
                String value = null;
                value = dataObject instanceof DateDataObject ? this.sdf.format(dataObject.getValue()) : dataObject.getValue().toString();
                if (dataObject instanceof StringDataObject && this.xmlChars.matcher(value).find()) {
                    xtw.writeCData(value);
                } else {
                    xtw.writeCharacters(value);
                }
            }
            xtw.writeEndElement();
        }
        return didWriteExtensionStartElement;
    }

    @Override
    protected void writeAdditionalChildElements(BaseElement element, BpmnModel model, XMLStreamWriter xtw) throws Exception {
    }
}

