/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.bpmn.converter;

import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.converter.BaseBpmnXMLConverter;
import org.flowable.bpmn.converter.export.FieldExtensionExport;
import org.flowable.bpmn.converter.util.BpmnXMLUtil;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.ImplementationType;
import org.flowable.bpmn.model.SendTask;

public class SendTaskXMLConverter
extends BaseBpmnXMLConverter {
    @Override
    public Class<? extends BaseElement> getBpmnElementType() {
        return SendTask.class;
    }

    @Override
    protected String getXMLElementName() {
        return "sendTask";
    }

    @Override
    protected BaseElement convertXMLToElement(XMLStreamReader xtr, BpmnModel model) throws Exception {
        SendTask sendTask = new SendTask();
        BpmnXMLUtil.addXMLLocation((BaseElement)sendTask, xtr);
        sendTask.setType(BpmnXMLUtil.getAttributeValue("type", xtr));
        if ("##WebService".equals(xtr.getAttributeValue(null, "implementation"))) {
            sendTask.setImplementationType(ImplementationType.IMPLEMENTATION_TYPE_WEBSERVICE);
            sendTask.setOperationRef(this.parseOperationRef(xtr.getAttributeValue(null, "operationRef"), model));
        }
        this.parseChildElements(this.getXMLElementName(), (BaseElement)sendTask, model, xtr);
        return sendTask;
    }

    @Override
    protected void writeAdditionalAttributes(BaseElement element, BpmnModel model, XMLStreamWriter xtw) throws Exception {
        SendTask sendTask = (SendTask)element;
        if (StringUtils.isNotEmpty((CharSequence)sendTask.getType())) {
            this.writeQualifiedAttribute("type", sendTask.getType(), xtw);
        }
    }

    @Override
    protected boolean writeExtensionChildElements(BaseElement element, boolean didWriteExtensionStartElement, XMLStreamWriter xtw) throws Exception {
        SendTask sendTask = (SendTask)element;
        didWriteExtensionStartElement = FieldExtensionExport.writeFieldExtensions(sendTask.getFieldExtensions(), didWriteExtensionStartElement, xtw);
        return didWriteExtensionStartElement;
    }

    @Override
    protected void writeAdditionalChildElements(BaseElement element, BpmnModel model, XMLStreamWriter xtw) throws Exception {
    }

    protected String parseOperationRef(String operationRef, BpmnModel model) {
        String result = null;
        if (StringUtils.isNotEmpty((CharSequence)operationRef)) {
            int indexOfP = operationRef.indexOf(58);
            if (indexOfP != -1) {
                String prefix = operationRef.substring(0, indexOfP);
                String resolvedNamespace = model.getNamespace(prefix);
                result = resolvedNamespace + ":" + operationRef.substring(indexOfP + 1);
            } else {
                result = model.getTargetNamespace() + ":" + operationRef;
            }
        }
        return result;
    }
}

